/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.client.impl.RaftClientRpcWithProxy;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.RaftGrpcUtil;
import org.apache.ratis.grpc.client.RaftClientProtocolClient;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.ReinitializeRequest;
import org.apache.ratis.protocol.ServerInformationRequest;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.shaded.io.grpc.stub.StreamObserver;
import org.apache.ratis.shaded.proto.RaftProtos;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.PeerProxyMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcClientRpc
extends RaftClientRpcWithProxy<RaftClientProtocolClient> {
    public static final Logger LOG = LoggerFactory.getLogger(GrpcClientRpc.class);
    private final ClientId clientId;
    private final int maxMessageSize;

    public GrpcClientRpc(ClientId clientId, RaftProperties properties) {
        super(new PeerProxyMap(clientId.toString(), p -> new RaftClientProtocolClient(clientId, (RaftPeer)p, properties)));
        this.clientId = clientId;
        this.maxMessageSize = GrpcConfigKeys.messageSizeMax(properties).getSizeInt();
    }

    public CompletableFuture<RaftClientReply> sendRequestAsync(RaftClientRequest request) {
        RaftPeerId serverId = request.getServerId();
        try {
            RaftClientProtocolClient proxy = (RaftClientProtocolClient)this.getProxies().getProxy(serverId);
            return proxy.getAppendStreamObservers().onNext(request);
        }
        catch (IOException e) {
            return JavaUtils.completeExceptionally((Throwable)e);
        }
    }

    public RaftClientReply sendRequest(RaftClientRequest request) throws IOException {
        RaftPeerId serverId = request.getServerId();
        RaftClientProtocolClient proxy = (RaftClientProtocolClient)this.getProxies().getProxy(serverId);
        if (request instanceof ReinitializeRequest) {
            RaftProtos.ReinitializeRequestProto proto = ClientProtoUtils.toReinitializeRequestProto((ReinitializeRequest)((ReinitializeRequest)request));
            return ClientProtoUtils.toRaftClientReply((RaftProtos.RaftClientReplyProto)proxy.reinitialize(proto));
        }
        if (request instanceof SetConfigurationRequest) {
            RaftProtos.SetConfigurationRequestProto setConf = ClientProtoUtils.toSetConfigurationRequestProto((SetConfigurationRequest)((SetConfigurationRequest)request));
            return ClientProtoUtils.toRaftClientReply((RaftProtos.RaftClientReplyProto)proxy.setConfiguration(setConf));
        }
        if (request instanceof ServerInformationRequest) {
            RaftProtos.ServerInformationRequestProto proto = ClientProtoUtils.toServerInformationRequestProto((ServerInformationRequest)((ServerInformationRequest)request));
            return ClientProtoUtils.toServerInformationReply((RaftProtos.ServerInformationReplyProto)proxy.serverInformation(proto));
        }
        CompletableFuture<RaftClientReply> f = this.sendRequest(request, proxy);
        try {
            return f.get();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted while waiting for response of request " + request);
        }
        catch (ExecutionException e) {
            throw IOUtils.toIOException((ExecutionException)e);
        }
    }

    private CompletableFuture<RaftClientReply> sendRequest(final RaftClientRequest request, RaftClientProtocolClient proxy) throws IOException {
        RaftProtos.RaftClientRequestProto requestProto = this.toRaftClientRequestProto(request);
        final CompletableFuture replyFuture = new CompletableFuture();
        StreamObserver<RaftProtos.RaftClientRequestProto> requestObserver = proxy.appendWithTimeout(new StreamObserver<RaftProtos.RaftClientReplyProto>(){

            public void onNext(RaftProtos.RaftClientReplyProto value) {
                replyFuture.complete(value);
            }

            public void onError(Throwable t) {
                replyFuture.completeExceptionally(RaftGrpcUtil.unwrapIOException(t));
            }

            public void onCompleted() {
                if (!replyFuture.isDone()) {
                    replyFuture.completeExceptionally(new IOException(GrpcClientRpc.this.clientId + ": Stream completed but no reply for request " + request));
                }
            }
        });
        requestObserver.onNext((Object)requestProto);
        requestObserver.onCompleted();
        return replyFuture.thenApply(ClientProtoUtils::toRaftClientReply);
    }

    private RaftProtos.RaftClientRequestProto toRaftClientRequestProto(RaftClientRequest request) throws IOException {
        RaftProtos.RaftClientRequestProto proto = ClientProtoUtils.toRaftClientRequestProto((RaftClientRequest)request);
        if (proto.getSerializedSize() > this.maxMessageSize) {
            throw new IOException(this.clientId + ": Message size:" + proto.getSerializedSize() + " exceeds maximum:" + this.maxMessageSize);
        }
        return proto;
    }
}

