/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.function.Supplier;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.client.RaftClientProtocolService;
import org.apache.ratis.grpc.server.AdminProtocolService;
import org.apache.ratis.grpc.server.RaftServerProtocolClient;
import org.apache.ratis.grpc.server.RaftServerProtocolService;
import org.apache.ratis.protocol.AdminAsynchronousProtocol;
import org.apache.ratis.protocol.RaftClientAsynchronousProtocol;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.RaftServerRpc;
import org.apache.ratis.server.impl.RaftServerRpcWithProxy;
import org.apache.ratis.shaded.com.google.protobuf.ByteString;
import org.apache.ratis.shaded.io.grpc.BindableService;
import org.apache.ratis.shaded.io.grpc.Server;
import org.apache.ratis.shaded.io.grpc.ServerBuilder;
import org.apache.ratis.shaded.io.grpc.netty.NettyServerBuilder;
import org.apache.ratis.shaded.proto.RaftProtos;
import org.apache.ratis.util.CodeInjectionForTesting;
import org.apache.ratis.util.ExitUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.PeerProxyMap;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftGRpcService
extends RaftServerRpcWithProxy<RaftServerProtocolClient, PeerProxyMap<RaftServerProtocolClient>> {
    static final Logger LOG = LoggerFactory.getLogger(RaftGRpcService.class);
    public static final String GRPC_SEND_SERVER_REQUEST = RaftGRpcService.class.getSimpleName() + ".sendRequest";
    private final Server server;
    private final Supplier<InetSocketAddress> addressSupplier;

    public static Builder newBuilder() {
        return new Builder();
    }

    private RaftGRpcService(RaftServer server) {
        this(server, () -> ((RaftServer)server).getId(), GrpcConfigKeys.Server.port(server.getProperties()), GrpcConfigKeys.messageSizeMax(server.getProperties()), RaftServerConfigKeys.Log.Appender.bufferCapacity((RaftProperties)server.getProperties()), GrpcConfigKeys.flowControlWindow(server.getProperties()), RaftServerConfigKeys.Rpc.requestTimeout((RaftProperties)server.getProperties()));
    }

    private RaftGRpcService(RaftServer raftServer, Supplier<RaftPeerId> idSupplier, int port, SizeInBytes grpcMessageSizeMax, SizeInBytes appenderBufferSize, SizeInBytes flowControlWindow, TimeDuration requestTimeoutDuration) {
        super(idSupplier, id -> new PeerProxyMap(id.toString(), p -> new RaftServerProtocolClient((RaftPeer)p, flowControlWindow.getSizeInt(), requestTimeoutDuration)));
        if (appenderBufferSize.getSize() > grpcMessageSizeMax.getSize()) {
            throw new IllegalArgumentException("Illegal configuration: raft.server.log.appender.buffer.capacity = " + appenderBufferSize + " > " + "raft.grpc.message.size.max" + " = " + grpcMessageSizeMax);
        }
        this.server = ((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)ServerBuilder.forPort((int)port)).maxMessageSize(grpcMessageSizeMax.getSizeInt()).flowControlWindow(flowControlWindow.getSizeInt()).addService((BindableService)new RaftServerProtocolService(idSupplier, raftServer))).addService((BindableService)new RaftClientProtocolService(idSupplier, (RaftClientAsynchronousProtocol)raftServer))).addService((BindableService)new AdminProtocolService((AdminAsynchronousProtocol)raftServer))).build();
        this.addressSupplier = JavaUtils.memoize(() -> new InetSocketAddress(port != 0 ? port : this.server.getPort()));
    }

    public SupportedRpcType getRpcType() {
        return SupportedRpcType.GRPC;
    }

    public void startImpl() {
        try {
            this.server.start();
        }
        catch (IOException e) {
            ExitUtils.terminate((int)1, (String)"Failed to start Grpc server", (Throwable)e, (Logger)LOG);
        }
        LOG.info("{}: {} started, listening on {}", new Object[]{this.getId(), ((Object)((Object)this)).getClass().getSimpleName(), this.getInetSocketAddress()});
    }

    public void closeImpl() {
        if (this.server != null) {
            this.server.shutdown();
        }
        super.closeImpl();
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.addressSupplier.get();
    }

    public RaftProtos.AppendEntriesReplyProto appendEntries(RaftProtos.AppendEntriesRequestProto request) throws IOException {
        throw new UnsupportedOperationException("Blocking AppendEntries call is not supported");
    }

    public RaftProtos.InstallSnapshotReplyProto installSnapshot(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
        throw new UnsupportedOperationException("Blocking InstallSnapshot call is not supported");
    }

    public RaftProtos.RequestVoteReplyProto requestVote(RaftProtos.RequestVoteRequestProto request) throws IOException {
        CodeInjectionForTesting.execute((String)GRPC_SEND_SERVER_REQUEST, (Object)this.getId(), null, (Object[])new Object[]{request});
        RaftPeerId target = RaftPeerId.valueOf((ByteString)request.getServerRequest().getReplyId());
        return ((RaftServerProtocolClient)this.getProxies().getProxy(target)).requestVote(request);
    }

    public static class Builder
    extends RaftServerRpc.Builder<Builder, RaftGRpcService> {
        private Builder() {
        }

        public Builder getThis() {
            return this;
        }

        public RaftGRpcService build() {
            return new RaftGRpcService(this.getServer());
        }
    }
}

