/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.hadooprpc.client;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.ratis.client.impl.RaftClientRpcWithProxy;
import org.apache.ratis.hadooprpc.client.CombinedClientProtocolClientSideTranslatorPB;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.GroupMismatchException;
import org.apache.ratis.protocol.LeaderNotReadyException;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftException;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.ReconfigurationInProgressException;
import org.apache.ratis.protocol.ReconfigurationTimeoutException;
import org.apache.ratis.protocol.ReinitializeRequest;
import org.apache.ratis.protocol.ServerInformationRequest;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.StateMachineException;
import org.apache.ratis.util.PeerProxyMap;

public class HadoopClientRpc
extends RaftClientRpcWithProxy<CombinedClientProtocolClientSideTranslatorPB> {
    public HadoopClientRpc(ClientId clientId, Configuration conf) {
        super(new PeerProxyMap(clientId.toString(), p -> new CombinedClientProtocolClientSideTranslatorPB(p.getAddress(), conf)));
    }

    public RaftClientReply sendRequest(RaftClientRequest request) throws IOException {
        RaftPeerId serverId = request.getServerId();
        CombinedClientProtocolClientSideTranslatorPB proxy = (CombinedClientProtocolClientSideTranslatorPB)this.getProxies().getProxy(serverId);
        try {
            if (request instanceof ReinitializeRequest) {
                return proxy.reinitialize((ReinitializeRequest)request);
            }
            if (request instanceof SetConfigurationRequest) {
                return proxy.setConfiguration((SetConfigurationRequest)request);
            }
            if (request instanceof ServerInformationRequest) {
                return proxy.getInfo((ServerInformationRequest)request);
            }
            return proxy.submitClientRequest(request);
        }
        catch (RemoteException e) {
            throw e.unwrapRemoteException(new Class[]{StateMachineException.class, ReconfigurationTimeoutException.class, ReconfigurationInProgressException.class, RaftException.class, LeaderNotReadyException.class, GroupMismatchException.class});
        }
    }
}

