/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.hadooprpc.client;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.hadooprpc.client.CombinedClientProtocolPB;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.ReinitializeRequest;
import org.apache.ratis.protocol.ServerInformationReply;
import org.apache.ratis.protocol.ServerInformationRequest;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.shaded.com.google.protobuf.RpcController;
import org.apache.ratis.shaded.com.google.protobuf.ServiceException;
import org.apache.ratis.shaded.proto.RaftProtos;

@InterfaceAudience.Private
public class CombinedClientProtocolServerSideTranslatorPB
implements CombinedClientProtocolPB {
    private final RaftServer impl;

    public CombinedClientProtocolServerSideTranslatorPB(RaftServer impl) {
        this.impl = impl;
    }

    public RaftProtos.RaftClientReplyProto submitClientRequest(RpcController unused, RaftProtos.RaftClientRequestProto proto) throws ServiceException {
        RaftClientRequest request = ClientProtoUtils.toRaftClientRequest((RaftProtos.RaftClientRequestProto)proto);
        try {
            RaftClientReply reply = this.impl.submitClientRequest(request);
            return ClientProtoUtils.toRaftClientReplyProto((RaftClientReply)reply);
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public RaftProtos.RaftClientReplyProto setConfiguration(RpcController unused, RaftProtos.SetConfigurationRequestProto proto) throws ServiceException {
        try {
            SetConfigurationRequest request = ClientProtoUtils.toSetConfigurationRequest((RaftProtos.SetConfigurationRequestProto)proto);
            RaftClientReply reply = this.impl.setConfiguration(request);
            return ClientProtoUtils.toRaftClientReplyProto((RaftClientReply)reply);
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public RaftProtos.RaftClientReplyProto reinitialize(RpcController controller, RaftProtos.ReinitializeRequestProto proto) throws ServiceException {
        try {
            ReinitializeRequest request = ClientProtoUtils.toReinitializeRequest((RaftProtos.ReinitializeRequestProto)proto);
            RaftClientReply reply = this.impl.reinitialize(request);
            return ClientProtoUtils.toRaftClientReplyProto((RaftClientReply)reply);
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public RaftProtos.ServerInformationReplyProto serverInformation(RpcController controller, RaftProtos.ServerInformationRequestProto proto) throws ServiceException {
        try {
            ServerInformationRequest request = ClientProtoUtils.toServerInformationRequest((RaftProtos.ServerInformationRequestProto)proto);
            ServerInformationReply reply = this.impl.getInfo(request);
            return ClientProtoUtils.toServerInformationReplyProto((ServerInformationReply)reply);
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }
}

