/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.hadooprpc.client;

import java.io.IOException;
import java.util.function.Function;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.hadooprpc.Proxy;
import org.apache.ratis.hadooprpc.client.CombinedClientProtocol;
import org.apache.ratis.hadooprpc.client.CombinedClientProtocolPB;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.ReinitializeRequest;
import org.apache.ratis.protocol.ServerInformationReply;
import org.apache.ratis.protocol.ServerInformationRequest;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.shaded.com.google.protobuf.ServiceException;
import org.apache.ratis.shaded.proto.RaftProtos;
import org.apache.ratis.util.CheckedFunction;
import org.apache.ratis.util.ProtoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CombinedClientProtocolClientSideTranslatorPB
extends Proxy<CombinedClientProtocolPB>
implements CombinedClientProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(CombinedClientProtocolClientSideTranslatorPB.class);

    public CombinedClientProtocolClientSideTranslatorPB(String addressStr, Configuration conf) throws IOException {
        super(CombinedClientProtocolPB.class, addressStr, conf);
    }

    public RaftClientReply submitClientRequest(RaftClientRequest request) throws IOException {
        return CombinedClientProtocolClientSideTranslatorPB.handleRequest(request, ClientProtoUtils::toRaftClientRequestProto, ClientProtoUtils::toRaftClientReply, p -> ((CombinedClientProtocolPB)this.getProtocol()).submitClientRequest(null, (RaftProtos.RaftClientRequestProto)p));
    }

    public RaftClientReply setConfiguration(SetConfigurationRequest request) throws IOException {
        return CombinedClientProtocolClientSideTranslatorPB.handleRequest(request, ClientProtoUtils::toSetConfigurationRequestProto, ClientProtoUtils::toRaftClientReply, p -> ((CombinedClientProtocolPB)this.getProtocol()).setConfiguration(null, (RaftProtos.SetConfigurationRequestProto)p));
    }

    public RaftClientReply reinitialize(ReinitializeRequest request) throws IOException {
        return CombinedClientProtocolClientSideTranslatorPB.handleRequest(request, ClientProtoUtils::toReinitializeRequestProto, ClientProtoUtils::toRaftClientReply, p -> ((CombinedClientProtocolPB)this.getProtocol()).reinitialize(null, (RaftProtos.ReinitializeRequestProto)p));
    }

    public ServerInformationReply getInfo(ServerInformationRequest request) throws IOException {
        return CombinedClientProtocolClientSideTranslatorPB.handleRequest(request, ClientProtoUtils::toServerInformationRequestProto, ClientProtoUtils::toServerInformationReply, p -> ((CombinedClientProtocolPB)this.getProtocol()).serverInformation(null, (RaftProtos.ServerInformationRequestProto)p));
    }

    static <REQUEST extends RaftClientRequest, REPLY extends RaftClientReply, PROTO_REQ, PROTO_REP> REPLY handleRequest(REQUEST request, Function<REQUEST, PROTO_REQ> reqToProto, Function<PROTO_REP, REPLY> repToProto, CheckedFunction<PROTO_REQ, PROTO_REP, ServiceException> handler) throws IOException {
        PROTO_REQ proto = reqToProto.apply(request);
        try {
            Object reply = handler.apply(proto);
            return (REPLY)((RaftClientReply)repToProto.apply(reply));
        }
        catch (ServiceException se) {
            LOG.trace("Failed to handle " + request, (Throwable)se);
            throw ProtoUtils.toIOException((ServiceException)se);
        }
    }
}

