/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.hadooprpc;

import java.net.InetSocketAddress;
import java.util.function.BiConsumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.ratis.conf.ConfUtils;
import org.apache.ratis.conf.Parameters;

public interface HadoopConfigKeys {
    public static final String PREFIX = "raft.hadoop";
    public static final String CONF_PARAMETER = "raft.hadoop.conf";
    public static final Class<Configuration> CONF_CLASS = Configuration.class;

    public static Configuration getConf(Parameters parameters) {
        return (Configuration)parameters.get(CONF_PARAMETER, CONF_CLASS);
    }

    public static void setConf(Parameters parameters, Configuration conf) {
        parameters.put(CONF_PARAMETER, (Object)conf, Configuration.class);
    }

    public static void main(String[] args) {
        ConfUtils.printAll(HadoopConfigKeys.class);
    }

    public static interface Ipc {
        public static final String PREFIX = "raft.hadoop.ipc";
        public static final String ADDRESS_KEY = "raft.hadoop.ipc.address";
        public static final int PORT_DEFAULT = 10718;
        public static final String ADDRESS_DEFAULT = "0.0.0.0:10718";
        public static final String HANDLERS_KEY = "raft.hadoop.ipc.handlers";
        public static final int HANDLERS_DEFAULT = 10;

        public static int handlers(Configuration conf) {
            return ConfUtils.getInt((arg_0, arg_1) -> ((Configuration)conf).getInt(arg_0, arg_1), (String)HANDLERS_KEY, (int)10, (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)1)});
        }

        public static void setHandlers(Configuration conf, int handers) {
            ConfUtils.set((arg_0, arg_1) -> ((Configuration)conf).setInt(arg_0, arg_1), (String)HANDLERS_KEY, (Object)handers, (BiConsumer[])new BiConsumer[0]);
        }

        public static InetSocketAddress address(Configuration conf) {
            return ConfUtils.getInetSocketAddress((arg_0, arg_1) -> ((Configuration)conf).getTrimmed(arg_0, arg_1), (String)ADDRESS_KEY, (String)ADDRESS_DEFAULT);
        }

        public static void setAddress(Configuration conf, String address) {
            ConfUtils.set((arg_0, arg_1) -> ((Configuration)conf).set(arg_0, arg_1), (String)ADDRESS_KEY, (Object)address, (BiConsumer[])new BiConsumer[0]);
        }
    }
}

