/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

public class Timestamp
implements Comparable<Timestamp> {
    private static final long NANOSECONDS_PER_MILLISECOND = 1000000L;
    private static final long START_TIME = System.nanoTime();
    private final long nanos;

    public static Timestamp latest(Timestamp a, Timestamp b) {
        return a.compareTo(b) > 0 ? a : b;
    }

    private Timestamp(long nanos) {
        this.nanos = nanos;
    }

    public Timestamp() {
        this(System.nanoTime());
    }

    public Timestamp addTimeMs(long milliseconds) {
        return new Timestamp(this.nanos + milliseconds * 1000000L);
    }

    public long elapsedTimeMs() {
        long d = System.nanoTime() - this.nanos;
        return d / 1000000L;
    }

    @Override
    public int compareTo(Timestamp that) {
        long d = this.nanos - that.nanos;
        return d > 0L ? 1 : (d == 0L ? 0 : -1);
    }

    public String toString() {
        return (this.nanos - START_TIME) / 1000000L + "ms";
    }
}

