/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.shaded.com.google.protobuf.ByteString;
import org.apache.ratis.shaded.com.google.protobuf.ServiceException;
import org.apache.ratis.shaded.proto.RaftProtos;

public interface ProtoUtils {
    public static ByteString writeObject2ByteString(Object obj) {
        ByteString.Output byteOut = ByteString.newOutput();
        try (ObjectOutputStream objOut = new ObjectOutputStream((OutputStream)byteOut);){
            objOut.writeObject(obj);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException when writing an object to a ByteString.", e);
        }
        return byteOut.toByteString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object toObject(ByteString bytes) {
        try (ObjectInputStream in = new ObjectInputStream(bytes.newInput());){
            Object object = in.readObject();
            return object;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException when reading an object from a ByteString.", e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public static ByteString toByteString(String string) {
        return ByteString.copyFromUtf8((String)string);
    }

    public static ByteString toByteString(byte[] bytes) {
        return ProtoUtils.toByteString(bytes, 0, bytes.length);
    }

    public static ByteString toByteString(byte[] bytes, int offset, int size) {
        return bytes.length == 0 ? ByteString.EMPTY : ByteString.copyFrom((byte[])bytes, (int)offset, (int)size);
    }

    public static RaftProtos.RaftPeerProto toRaftPeerProto(RaftPeer peer) {
        RaftProtos.RaftPeerProto.Builder builder = RaftProtos.RaftPeerProto.newBuilder().setId(peer.getId().toByteString());
        if (peer.getAddress() != null) {
            builder.setAddress(peer.getAddress());
        }
        return builder.build();
    }

    public static RaftPeer toRaftPeer(RaftProtos.RaftPeerProto p) {
        return new RaftPeer(RaftPeerId.valueOf(p.getId()), p.getAddress());
    }

    public static RaftPeer[] toRaftPeerArray(List<RaftProtos.RaftPeerProto> protos) {
        RaftPeer[] peers = new RaftPeer[protos.size()];
        for (int i = 0; i < peers.length; ++i) {
            peers[i] = ProtoUtils.toRaftPeer(protos.get(i));
        }
        return peers;
    }

    public static Iterable<RaftProtos.RaftPeerProto> toRaftPeerProtos(final Collection<RaftPeer> peers) {
        return () -> new Iterator<RaftProtos.RaftPeerProto>(){
            final Iterator i;
            {
                this.i = peers.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public RaftProtos.RaftPeerProto next() {
                return ProtoUtils.toRaftPeerProto((RaftPeer)this.i.next());
            }
        };
    }

    public static RaftGroupId toRaftGroupId(RaftProtos.RaftGroupIdProto proto) {
        return RaftGroupId.valueOf(proto.getId());
    }

    public static RaftProtos.RaftGroupIdProto.Builder toRaftGroupIdProtoBuilder(RaftGroupId id) {
        return RaftProtos.RaftGroupIdProto.newBuilder().setId(id.toByteString());
    }

    public static RaftGroup toRaftGroup(RaftProtos.RaftGroupProto proto) {
        return new RaftGroup(ProtoUtils.toRaftGroupId(proto.getGroupId()), ProtoUtils.toRaftPeerArray(proto.getPeersList()));
    }

    public static RaftProtos.RaftGroupProto.Builder toRaftGroupProtoBuilder(RaftGroup group) {
        return RaftProtos.RaftGroupProto.newBuilder().setGroupId(ProtoUtils.toRaftGroupIdProtoBuilder(group.getGroupId())).addAllPeers(ProtoUtils.toRaftPeerProtos(group.getPeers()));
    }

    public static RaftProtos.CommitInfoProto toCommitInfoProto(RaftPeer peer, long commitIndex) {
        return RaftProtos.CommitInfoProto.newBuilder().setServer(ProtoUtils.toRaftPeerProto(peer)).setCommitIndex(commitIndex).build();
    }

    public static void addCommitInfos(Collection<RaftProtos.CommitInfoProto> commitInfos, Consumer<RaftProtos.CommitInfoProto> adder) {
        if (commitInfos != null && !commitInfos.isEmpty()) {
            commitInfos.stream().forEach(i -> adder.accept((RaftProtos.CommitInfoProto)i));
        }
    }

    public static String toString(RaftProtos.CommitInfoProto proto) {
        return RaftPeerId.valueOf(proto.getServer().getId()) + ":c" + proto.getCommitIndex();
    }

    public static String toString(Collection<RaftProtos.CommitInfoProto> protos) {
        return protos.stream().map(ProtoUtils::toString).collect(Collectors.toList()).toString();
    }

    public static boolean isConfigurationLogEntry(RaftProtos.LogEntryProto entry) {
        return entry.getLogEntryBodyCase() == RaftProtos.LogEntryProto.LogEntryBodyCase.CONFIGURATIONENTRY;
    }

    public static RaftProtos.LogEntryProto toLogEntryProto(RaftProtos.SMLogEntryProto operation, long term, long index, ClientId clientId, long callId) {
        return RaftProtos.LogEntryProto.newBuilder().setTerm(term).setIndex(index).setSmLogEntry(operation).setClientId(clientId.toByteString()).setCallId(callId).build();
    }

    public static RaftProtos.LogEntryProto removeStateMachineData(RaftProtos.LogEntryProto entry) {
        if (entry.getLogEntryBodyCase() != RaftProtos.LogEntryProto.LogEntryBodyCase.SMLOGENTRY) {
            return entry;
        }
        RaftProtos.SMLogEntryProto smLog = entry.getSmLogEntry();
        if (smLog.getStateMachineData().isEmpty()) {
            return entry;
        }
        return RaftProtos.LogEntryProto.newBuilder((RaftProtos.LogEntryProto)entry).setSmLogEntry(RaftProtos.SMLogEntryProto.newBuilder().setData(smLog.getData())).build();
    }

    public static IOException toIOException(ServiceException se) {
        Throwable t = se.getCause();
        if (t == null) {
            return new IOException((Throwable)se);
        }
        return t instanceof IOException ? (IOException)t : new IOException((Throwable)se);
    }

    public static String toString(RaftProtos.RaftRpcRequestProto proto) {
        return proto.getRequestorId().toStringUtf8() + "->" + proto.getReplyId().toStringUtf8() + "#" + proto.getCallId();
    }

    public static String toString(RaftProtos.RaftRpcReplyProto proto) {
        return proto.getRequestorId().toStringUtf8() + "<-" + proto.getReplyId().toStringUtf8() + "#" + proto.getCallId() + ":" + (proto.getSuccess() ? "OK" : "FAIL");
    }

    public static String toString(RaftProtos.RequestVoteReplyProto proto) {
        return ProtoUtils.toString(proto.getServerReply()) + "-t" + proto.getTerm();
    }

    public static String toString(RaftProtos.AppendEntriesReplyProto proto) {
        return ProtoUtils.toString(proto.getServerReply()) + "-t" + proto.getTerm() + ", nextIndex=" + proto.getNextIndex() + ", result: " + proto.getResult();
    }
}

