/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;

public class RaftGroup {
    private static RaftGroup EMPTY_GROUP = new RaftGroup(RaftGroupId.emptyGroupId());
    private final RaftGroupId groupId;
    private final Map<RaftPeerId, RaftPeer> peers;

    public static RaftGroup emptyGroup() {
        return EMPTY_GROUP;
    }

    public RaftGroup(RaftGroupId groupId) {
        this(groupId, Collections.emptyList());
    }

    public RaftGroup(RaftGroupId groupId, RaftPeer ... peers) {
        this(groupId, Arrays.asList(peers));
    }

    public RaftGroup(RaftGroupId groupId, Collection<RaftPeer> peers) {
        this.groupId = Objects.requireNonNull(groupId, "groupId == null");
        if (peers == null || peers.isEmpty()) {
            this.peers = Collections.emptyMap();
        } else {
            HashMap map = new HashMap();
            peers.stream().forEach(p -> map.put(p.getId(), p));
            this.peers = Collections.unmodifiableMap(map);
        }
    }

    public RaftGroupId getGroupId() {
        return this.groupId;
    }

    public Collection<RaftPeer> getPeers() {
        return this.peers.values();
    }

    public RaftPeer getPeer(RaftPeerId id) {
        return this.peers.get(Objects.requireNonNull(id, "id == null"));
    }

    public String toString() {
        return this.groupId + ":" + this.peers.values();
    }
}

