/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import java.util.Objects;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientMessage;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.shaded.proto.RaftProtos;
import org.apache.ratis.util.Preconditions;

public class RaftClientRequest
extends RaftClientMessage {
    private static final Type WRITE_DEFAULT = new Type(RaftProtos.WriteRequestTypeProto.getDefaultInstance());
    private static final Type WRITE_ALL = new Type(RaftProtos.WriteRequestTypeProto.newBuilder().setReplication(RaftProtos.ReplicationLevel.ALL).build());
    private static final Type DEFAULT_READ = new Type(RaftProtos.ReadRequestTypeProto.getDefaultInstance());
    private static final Type DEFAULT_STALE_READ = new Type(RaftProtos.StaleReadRequestTypeProto.getDefaultInstance());
    private final long callId;
    private final long seqNum;
    private final Message message;
    private final Type type;

    public static Type writeRequestType(RaftProtos.ReplicationLevel replication) {
        switch (replication) {
            case MAJORITY: {
                return WRITE_DEFAULT;
            }
            case ALL: {
                return WRITE_ALL;
            }
        }
        throw new IllegalArgumentException("Unexpected replication: " + replication);
    }

    public static Type readRequestType() {
        return DEFAULT_READ;
    }

    public static Type staleReadRequestType(long minIndex) {
        return minIndex == 0L ? DEFAULT_STALE_READ : new Type(RaftProtos.StaleReadRequestTypeProto.newBuilder().setMinIndex(minIndex).build());
    }

    public RaftClientRequest(ClientId clientId, RaftPeerId serverId, RaftGroupId groupId, long callId) {
        this(clientId, serverId, groupId, callId, 0L, null, WRITE_DEFAULT);
    }

    public RaftClientRequest(ClientId clientId, RaftPeerId serverId, RaftGroupId groupId, long callId, long seqNum, Message message, Type type) {
        super(clientId, serverId, groupId);
        this.callId = callId;
        this.seqNum = seqNum;
        this.message = message;
        this.type = type;
    }

    @Override
    public final boolean isRequest() {
        return true;
    }

    public long getCallId() {
        return this.callId;
    }

    public long getSeqNum() {
        return this.seqNum;
    }

    public Message getMessage() {
        return this.message;
    }

    public Type getType() {
        return this.type;
    }

    public boolean is(RaftProtos.RaftClientRequestProto.TypeCase typeCase) {
        return this.getType().getTypeCase() == typeCase;
    }

    @Override
    public String toString() {
        return super.toString() + ", cid=" + this.callId + ", seq=" + this.seqNum + " " + this.type + ", " + this.getMessage();
    }

    public static class Type {
        private final RaftProtos.RaftClientRequestProto.TypeCase typeCase;
        private final RaftProtos.WriteRequestTypeProto write;
        private final RaftProtos.ReadRequestTypeProto read;
        private final RaftProtos.StaleReadRequestTypeProto staleRead;

        public static Type valueOf(RaftProtos.WriteRequestTypeProto write) {
            return RaftClientRequest.writeRequestType(write.getReplication());
        }

        public static Type valueOf(RaftProtos.ReadRequestTypeProto read) {
            return DEFAULT_READ;
        }

        public static Type valueOf(RaftProtos.StaleReadRequestTypeProto staleRead) {
            return staleRead.getMinIndex() == 0L ? DEFAULT_STALE_READ : new Type(staleRead);
        }

        private Type(RaftProtos.WriteRequestTypeProto write) {
            this.typeCase = RaftProtos.RaftClientRequestProto.TypeCase.WRITE;
            this.write = Objects.requireNonNull(write);
            this.read = null;
            this.staleRead = null;
        }

        private Type(RaftProtos.ReadRequestTypeProto read) {
            this.typeCase = RaftProtos.RaftClientRequestProto.TypeCase.READ;
            this.write = null;
            this.read = Objects.requireNonNull(read);
            this.staleRead = null;
        }

        private Type(RaftProtos.StaleReadRequestTypeProto staleRead) {
            this.typeCase = RaftProtos.RaftClientRequestProto.TypeCase.STALEREAD;
            this.write = null;
            this.read = null;
            this.staleRead = Objects.requireNonNull(staleRead);
        }

        public RaftProtos.RaftClientRequestProto.TypeCase getTypeCase() {
            return this.typeCase;
        }

        public RaftProtos.WriteRequestTypeProto getWrite() {
            Preconditions.assertTrue(this.typeCase == RaftProtos.RaftClientRequestProto.TypeCase.WRITE);
            return this.write;
        }

        public RaftProtos.ReadRequestTypeProto getRead() {
            Preconditions.assertTrue(this.typeCase == RaftProtos.RaftClientRequestProto.TypeCase.READ);
            return this.read;
        }

        public RaftProtos.StaleReadRequestTypeProto getStaleRead() {
            Preconditions.assertTrue(this.typeCase == RaftProtos.RaftClientRequestProto.TypeCase.STALEREAD);
            return this.staleRead;
        }

        public String toString() {
            switch (this.typeCase) {
                case WRITE: {
                    RaftProtos.ReplicationLevel replication = this.write.getReplication();
                    return "RW" + (replication == RaftProtos.ReplicationLevel.MAJORITY ? "" : "-" + replication);
                }
                case READ: {
                    return "RO";
                }
                case STALEREAD: {
                    return "StaleRead(" + this.staleRead.getMinIndex() + ")";
                }
            }
            throw new IllegalStateException("Unexpected request type: " + this.typeCase);
        }
    }
}

