/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import org.apache.ratis.protocol.RaftException;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;

public class NotLeaderException
extends RaftException {
    private final RaftPeer suggestedLeader;
    private final RaftPeer[] peers;

    public NotLeaderException(RaftPeerId id, RaftPeer suggestedLeader, RaftPeer[] peers) {
        super("Server " + id + " is not the leader (" + suggestedLeader + "). Request must be sent to leader.");
        this.suggestedLeader = suggestedLeader;
        this.peers = peers == null ? RaftPeer.emptyArray() : peers;
    }

    public RaftPeer getSuggestedLeader() {
        return this.suggestedLeader;
    }

    public RaftPeer[] getPeers() {
        return this.peers;
    }
}

