/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.netty.client;

import java.io.IOException;
import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.client.impl.RaftClientRpcWithProxy;
import org.apache.ratis.netty.NettyRpcProxy;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.ReinitializeRequest;
import org.apache.ratis.protocol.ServerInformationRequest;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.shaded.proto.RaftProtos;
import org.apache.ratis.shaded.proto.netty.NettyProtos;
import org.apache.ratis.util.PeerProxyMap;

public class NettyClientRpc
extends RaftClientRpcWithProxy<NettyRpcProxy> {
    public NettyClientRpc(ClientId clientId) {
        super((PeerProxyMap)new NettyRpcProxy.PeerMap(clientId.toString()));
    }

    public RaftClientReply sendRequest(RaftClientRequest request) throws IOException {
        RaftProtos.RaftRpcRequestProto rpcRequest;
        RaftPeerId serverId = request.getServerId();
        NettyRpcProxy proxy = (NettyRpcProxy)this.getProxies().getProxy(serverId);
        NettyProtos.RaftNettyServerRequestProto.Builder b = NettyProtos.RaftNettyServerRequestProto.newBuilder();
        if (request instanceof ReinitializeRequest) {
            RaftProtos.ReinitializeRequestProto proto = ClientProtoUtils.toReinitializeRequestProto((ReinitializeRequest)((ReinitializeRequest)request));
            b.setReinitializeRequest(proto);
            rpcRequest = proto.getRpcRequest();
        } else if (request instanceof SetConfigurationRequest) {
            RaftProtos.SetConfigurationRequestProto proto = ClientProtoUtils.toSetConfigurationRequestProto((SetConfigurationRequest)((SetConfigurationRequest)request));
            b.setSetConfigurationRequest(proto);
            rpcRequest = proto.getRpcRequest();
        } else if (request instanceof ServerInformationRequest) {
            RaftProtos.ServerInformationRequestProto proto = ClientProtoUtils.toServerInformationRequestProto((ServerInformationRequest)((ServerInformationRequest)request));
            b.setServerInformationRequest(proto);
            rpcRequest = proto.getRpcRequest();
        } else {
            RaftProtos.RaftClientRequestProto proto = ClientProtoUtils.toRaftClientRequestProto((RaftClientRequest)request);
            b.setRaftClientRequest(proto);
            rpcRequest = proto.getRpcRequest();
        }
        if (request instanceof ServerInformationRequest) {
            return ClientProtoUtils.toServerInformationReply((RaftProtos.ServerInformationReplyProto)proxy.send(rpcRequest, b.build()).getServerInfoReply());
        }
        return ClientProtoUtils.toRaftClientReply((RaftProtos.RaftClientReplyProto)proxy.send(rpcRequest, b.build()).getRaftClientReply());
    }
}

