/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.NotLeaderException;
import org.apache.ratis.protocol.NotReplicatedException;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftException;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.ReinitializeRequest;
import org.apache.ratis.protocol.ServerInformationReply;
import org.apache.ratis.protocol.ServerInformationRequest;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.StateMachineException;
import org.apache.ratis.shaded.com.google.protobuf.ByteString;
import org.apache.ratis.shaded.proto.RaftProtos;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.ReflectionUtils;

public interface ClientProtoUtils {
    public static RaftProtos.RaftRpcReplyProto.Builder toRaftRpcReplyProtoBuilder(ByteString requestorId, ByteString replyId, RaftGroupId groupId, long callId, boolean success) {
        return RaftProtos.RaftRpcReplyProto.newBuilder().setRequestorId(requestorId).setReplyId(replyId).setRaftGroupId(ProtoUtils.toRaftGroupIdProtoBuilder((RaftGroupId)groupId)).setCallId(callId).setSuccess(success);
    }

    public static RaftProtos.RaftRpcRequestProto.Builder toRaftRpcRequestProtoBuilder(ByteString requesterId, ByteString replyId, RaftGroupId groupId, long callId, long seqNum) {
        return RaftProtos.RaftRpcRequestProto.newBuilder().setRequestorId(requesterId).setReplyId(replyId).setRaftGroupId(ProtoUtils.toRaftGroupIdProtoBuilder((RaftGroupId)groupId)).setCallId(callId).setSeqNum(seqNum);
    }

    public static RaftProtos.RaftRpcRequestProto.Builder toRaftRpcRequestProtoBuilder(ClientId requesterId, RaftPeerId replyId, RaftGroupId groupId, long callId, long seqNum) {
        return ClientProtoUtils.toRaftRpcRequestProtoBuilder(requesterId.toByteString(), replyId.toByteString(), groupId, callId, seqNum);
    }

    public static RaftProtos.RaftRpcRequestProto.Builder toRaftRpcRequestProtoBuilder(RaftClientRequest request) {
        return ClientProtoUtils.toRaftRpcRequestProtoBuilder(request.getClientId(), request.getServerId(), request.getRaftGroupId(), request.getCallId(), request.getSeqNum());
    }

    public static RaftClientRequest.Type toRaftClientRequestType(RaftProtos.RaftClientRequestProto p) {
        switch (p.getTypeCase()) {
            case WRITE: {
                return RaftClientRequest.Type.valueOf((RaftProtos.WriteRequestTypeProto)p.getWrite());
            }
            case READ: {
                return RaftClientRequest.Type.valueOf((RaftProtos.ReadRequestTypeProto)p.getRead());
            }
            case STALEREAD: {
                return RaftClientRequest.Type.valueOf((RaftProtos.StaleReadRequestTypeProto)p.getStaleRead());
            }
        }
        throw new IllegalArgumentException("Unexpected request type: " + p.getTypeCase() + " in request proto " + p);
    }

    public static RaftClientRequest toRaftClientRequest(RaftProtos.RaftClientRequestProto p) {
        RaftClientRequest.Type type = ClientProtoUtils.toRaftClientRequestType(p);
        RaftProtos.RaftRpcRequestProto request = p.getRpcRequest();
        return new RaftClientRequest(ClientId.valueOf((ByteString)request.getRequestorId()), RaftPeerId.valueOf((ByteString)request.getReplyId()), ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)request.getRaftGroupId()), request.getCallId(), request.getSeqNum(), ClientProtoUtils.toMessage(p.getMessage()), type);
    }

    public static RaftProtos.RaftClientRequestProto toRaftClientRequestProto(RaftClientRequest request) {
        RaftProtos.RaftClientRequestProto.Builder b = RaftProtos.RaftClientRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder(request)).setMessage(ClientProtoUtils.toClientMessageEntryProtoBuilder(request.getMessage()));
        RaftClientRequest.Type type = request.getType();
        switch (type.getTypeCase()) {
            case WRITE: {
                b.setWrite(type.getWrite());
                break;
            }
            case READ: {
                b.setRead(type.getRead());
                break;
            }
            case STALEREAD: {
                b.setStaleRead(type.getStaleRead());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected request type: " + request.getType() + " in request " + request);
            }
        }
        return b.build();
    }

    public static RaftProtos.RaftClientRequestProto toRaftClientRequestProto(ClientId clientId, RaftPeerId serverId, RaftGroupId groupId, long callId, long seqNum, ByteString content) {
        return RaftProtos.RaftClientRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder(clientId, serverId, groupId, callId, seqNum)).setWrite(RaftProtos.WriteRequestTypeProto.getDefaultInstance()).setMessage(ClientProtoUtils.toClientMessageEntryProtoBuilder(content)).build();
    }

    public static RaftProtos.RaftClientReplyProto toRaftClientReplyProto(RaftClientReply reply) {
        RaftProtos.RaftClientReplyProto.Builder b = RaftProtos.RaftClientReplyProto.newBuilder();
        if (reply != null) {
            b.setRpcReply(ClientProtoUtils.toRaftRpcReplyProtoBuilder(reply.getClientId().toByteString(), reply.getServerId().toByteString(), reply.getRaftGroupId(), reply.getCallId(), reply.isSuccess()));
            if (reply.getMessage() != null) {
                b.setMessage(ClientProtoUtils.toClientMessageEntryProtoBuilder(reply.getMessage()));
            }
            ProtoUtils.addCommitInfos((Collection)reply.getCommitInfos(), i -> b.addCommitInfos(i));
            NotLeaderException nle = reply.getNotLeaderException();
            if (nle != null) {
                RaftProtos.NotLeaderExceptionProto.Builder nleBuilder = RaftProtos.NotLeaderExceptionProto.newBuilder();
                RaftPeer suggestedLeader = nle.getSuggestedLeader();
                if (suggestedLeader != null) {
                    nleBuilder.setSuggestedLeader(ProtoUtils.toRaftPeerProto((RaftPeer)suggestedLeader));
                }
                nleBuilder.addAllPeersInConf(ProtoUtils.toRaftPeerProtos(Arrays.asList(nle.getPeers())));
                b.setNotLeaderException(nleBuilder.build());
            } else {
                StateMachineException sme = reply.getStateMachineException();
                if (sme != null) {
                    RaftProtos.StateMachineExceptionProto.Builder smeBuilder = RaftProtos.StateMachineExceptionProto.newBuilder();
                    Throwable t = sme.getCause() != null ? sme.getCause() : sme;
                    smeBuilder.setExceptionClassName(t.getClass().getName()).setErrorMsg(t.getMessage()).setStacktrace(ProtoUtils.writeObject2ByteString((Object)t.getStackTrace()));
                    b.setStateMachineException(smeBuilder.build());
                }
            }
            NotReplicatedException nre = reply.getNotReplicatedException();
            if (nre != null) {
                RaftProtos.NotReplicatedExceptionProto.Builder nreBuilder = RaftProtos.NotReplicatedExceptionProto.newBuilder().setCallId(nre.getCallId()).setReplication(nre.getRequiredReplication()).setLogIndex(nre.getLogIndex());
                b.setNotReplicatedException(nreBuilder);
            }
        }
        return b.build();
    }

    public static RaftProtos.ServerInformationReplyProto toServerInformationReplyProto(ServerInformationReply reply) {
        RaftProtos.ServerInformationReplyProto.Builder b = RaftProtos.ServerInformationReplyProto.newBuilder();
        if (reply != null) {
            b.setRpcReply(ClientProtoUtils.toRaftRpcReplyProtoBuilder(reply.getClientId().toByteString(), reply.getServerId().toByteString(), reply.getRaftGroupId(), reply.getCallId(), reply.isSuccess()));
            if (reply.getRaftGroupId() != null) {
                b.setGroup(ProtoUtils.toRaftGroupProtoBuilder((RaftGroup)reply.getGroup()));
            }
            ProtoUtils.addCommitInfos((Collection)reply.getCommitInfos(), i -> b.addCommitInfos(i));
        }
        return b.build();
    }

    public static RaftClientReply toRaftClientReply(RaftProtos.RaftClientReplyProto replyProto) {
        NotReplicatedException e;
        RaftProtos.RaftRpcReplyProto rp = replyProto.getRpcReply();
        if (replyProto.getExceptionDetailsCase().equals((Object)RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.NOTLEADEREXCEPTION)) {
            RaftProtos.NotLeaderExceptionProto nleProto = replyProto.getNotLeaderException();
            RaftPeer suggestedLeader = nleProto.hasSuggestedLeader() ? ProtoUtils.toRaftPeer((RaftProtos.RaftPeerProto)nleProto.getSuggestedLeader()) : null;
            RaftPeer[] peers = ProtoUtils.toRaftPeerArray((List)nleProto.getPeersInConfList());
            e = new NotLeaderException(RaftPeerId.valueOf((ByteString)rp.getReplyId()), suggestedLeader, peers);
        } else if (replyProto.getExceptionDetailsCase() == RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.NOTREPLICATEDEXCEPTION) {
            RaftProtos.NotReplicatedExceptionProto nre = replyProto.getNotReplicatedException();
            e = new NotReplicatedException(nre.getCallId(), nre.getReplication(), nre.getLogIndex());
        } else if (replyProto.getExceptionDetailsCase().equals((Object)RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.STATEMACHINEEXCEPTION)) {
            RaftProtos.StateMachineExceptionProto smeProto = replyProto.getStateMachineException();
            e = ClientProtoUtils.wrapStateMachineException(RaftPeerId.valueOf((ByteString)rp.getReplyId()), smeProto.getExceptionClassName(), smeProto.getErrorMsg(), smeProto.getStacktrace());
        } else {
            e = null;
        }
        ClientId clientId = ClientId.valueOf((ByteString)rp.getRequestorId());
        RaftGroupId groupId = ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)rp.getRaftGroupId());
        return new RaftClientReply(clientId, RaftPeerId.valueOf((ByteString)rp.getReplyId()), groupId, rp.getCallId(), rp.getSuccess(), ClientProtoUtils.toMessage(replyProto.getMessage()), (RaftException)e, (Collection)replyProto.getCommitInfosList());
    }

    public static ServerInformationReply toServerInformationReply(RaftProtos.ServerInformationReplyProto replyProto) {
        RaftProtos.RaftRpcReplyProto rp = replyProto.getRpcReply();
        ClientId clientId = ClientId.valueOf((ByteString)rp.getRequestorId());
        RaftGroupId groupId = ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)rp.getRaftGroupId());
        RaftGroup raftGroup = ProtoUtils.toRaftGroup((RaftProtos.RaftGroupProto)replyProto.getGroup());
        return new ServerInformationReply(clientId, RaftPeerId.valueOf((ByteString)rp.getReplyId()), groupId, rp.getCallId(), rp.getSuccess(), (Collection)replyProto.getCommitInfosList(), raftGroup);
    }

    public static StateMachineException wrapStateMachineException(RaftPeerId serverId, String className, String errorMsg, ByteString stackTraceBytes) {
        StateMachineException sme;
        if (className == null) {
            sme = new StateMachineException(errorMsg);
        } else {
            try {
                Class<?> clazz = Class.forName(className);
                Exception e = ReflectionUtils.instantiateException(clazz.asSubclass(Exception.class), (String)errorMsg, null);
                sme = new StateMachineException(serverId, (Throwable)e);
            }
            catch (Exception e) {
                sme = new StateMachineException(className + ": " + errorMsg);
            }
        }
        StackTraceElement[] stacktrace = (StackTraceElement[])ProtoUtils.toObject((ByteString)stackTraceBytes);
        sme.setStackTrace(stacktrace);
        return sme;
    }

    public static Message toMessage(RaftProtos.ClientMessageEntryProto p) {
        return Message.valueOf((ByteString)p.getContent());
    }

    public static RaftProtos.ClientMessageEntryProto.Builder toClientMessageEntryProtoBuilder(ByteString message) {
        return RaftProtos.ClientMessageEntryProto.newBuilder().setContent(message);
    }

    public static RaftProtos.ClientMessageEntryProto.Builder toClientMessageEntryProtoBuilder(Message message) {
        return ClientProtoUtils.toClientMessageEntryProtoBuilder(message.getContent());
    }

    public static SetConfigurationRequest toSetConfigurationRequest(RaftProtos.SetConfigurationRequestProto p) {
        RaftProtos.RaftRpcRequestProto m = p.getRpcRequest();
        RaftPeer[] peers = ProtoUtils.toRaftPeerArray((List)p.getPeersList());
        return new SetConfigurationRequest(ClientId.valueOf((ByteString)m.getRequestorId()), RaftPeerId.valueOf((ByteString)m.getReplyId()), ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)m.getRaftGroupId()), p.getRpcRequest().getCallId(), peers);
    }

    public static RaftProtos.SetConfigurationRequestProto toSetConfigurationRequestProto(SetConfigurationRequest request) {
        return RaftProtos.SetConfigurationRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder((RaftClientRequest)request)).addAllPeers(ProtoUtils.toRaftPeerProtos(Arrays.asList(request.getPeersInNewConf()))).build();
    }

    public static ReinitializeRequest toReinitializeRequest(RaftProtos.ReinitializeRequestProto p) {
        RaftProtos.RaftRpcRequestProto m = p.getRpcRequest();
        return new ReinitializeRequest(ClientId.valueOf((ByteString)m.getRequestorId()), RaftPeerId.valueOf((ByteString)m.getReplyId()), ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)m.getRaftGroupId()), m.getCallId(), ProtoUtils.toRaftGroup((RaftProtos.RaftGroupProto)p.getGroup()));
    }

    public static ServerInformationRequest toServerInformationRequest(RaftProtos.ServerInformationRequestProto p) {
        RaftProtos.RaftRpcRequestProto m = p.getRpcRequest();
        return new ServerInformationRequest(ClientId.valueOf((ByteString)m.getRequestorId()), RaftPeerId.valueOf((ByteString)m.getReplyId()), ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)m.getRaftGroupId()), m.getCallId());
    }

    public static RaftProtos.ReinitializeRequestProto toReinitializeRequestProto(ReinitializeRequest request) {
        return RaftProtos.ReinitializeRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder((RaftClientRequest)request)).setGroup(ProtoUtils.toRaftGroupProtoBuilder((RaftGroup)request.getGroup())).build();
    }

    public static RaftProtos.ServerInformationRequestProto toServerInformationRequestProto(ServerInformationRequest request) {
        return RaftProtos.ServerInformationRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder((RaftClientRequest)request)).build();
    }

    public static String toString(RaftProtos.RaftClientRequestProto proto) {
        RaftProtos.RaftRpcRequestProto rpc = proto.getRpcRequest();
        return ClientId.valueOf((ByteString)rpc.getRequestorId()) + "->" + rpc.getReplyId().toStringUtf8() + "#" + rpc.getCallId() + "-" + rpc.getSeqNum();
    }

    public static String toString(RaftProtos.RaftClientReplyProto proto) {
        RaftProtos.RaftRpcReplyProto rpc = proto.getRpcReply();
        return ClientId.valueOf((ByteString)rpc.getRequestorId()) + "<-" + rpc.getReplyId().toStringUtf8() + "#" + rpc.getCallId();
    }
}

