/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.ResourceGroups;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.CreatableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import com.microsoft.azure.management.resources.implementation.ResourceGroupImpl;
import com.microsoft.azure.management.resources.implementation.ResourceGroupInner;
import com.microsoft.azure.management.resources.implementation.ResourceGroupsInner;
import com.microsoft.azure.management.resources.implementation.ResourceManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import rx.Completable;
import rx.Observable;

final class ResourceGroupsImpl
extends CreatableResourcesImpl<ResourceGroup, ResourceGroupImpl, ResourceGroupInner>
implements ResourceGroups {
    private final ResourceGroupsInner client;
    private final ResourceManagementClientImpl serviceClient;

    ResourceGroupsImpl(ResourceManagementClientImpl serviceClient) {
        this.serviceClient = serviceClient;
        this.client = serviceClient.resourceGroups();
    }

    @Override
    public PagedList<ResourceGroup> list() {
        return this.wrapList(this.client.list());
    }

    @Override
    public PagedList<ResourceGroup> listByTag(String tagName, String tagValue) {
        return this.wrapList(this.client.list(Utils.createOdataFilterForTags(tagName, tagValue), null));
    }

    @Override
    public Observable<ResourceGroup> listByTagAsync(String tagName, String tagValue) {
        return this.wrapPageAsync(this.client.listAsync(Utils.createOdataFilterForTags(tagName, tagValue), null));
    }

    @Override
    public ResourceGroupImpl getByName(String name) {
        return this.wrapModel(this.client.get(name));
    }

    @Override
    public void deleteByName(String name) {
        this.deleteByNameAsync(name).await();
    }

    @Override
    public ServiceFuture<Void> deleteByNameAsync(String name, ServiceCallback<Void> callback) {
        return ServiceFuture.fromResponse(this.client.deleteWithServiceResponseAsync(name), callback);
    }

    @Override
    public Completable deleteByNameAsync(String name) {
        return this.client.deleteAsync(name).toCompletable();
    }

    @Override
    public ResourceGroupImpl define(String name) {
        return this.wrapModel(name);
    }

    @Override
    public boolean checkExistence(String name) {
        return this.contain(name);
    }

    @Override
    public boolean contain(String name) {
        return this.client.checkExistence(name);
    }

    @Override
    protected ResourceGroupImpl wrapModel(String name) {
        return new ResourceGroupImpl(new ResourceGroupInner().withName(name), this.serviceClient);
    }

    @Override
    protected ResourceGroupImpl wrapModel(ResourceGroupInner inner) {
        if (inner == null) {
            return null;
        }
        return new ResourceGroupImpl(inner, this.serviceClient);
    }

    @Override
    public void beginDeleteByName(String id) {
        this.beginDeleteByNameAsync(id).toBlocking().subscribe();
    }

    @Override
    public ServiceFuture<Void> beginDeleteByNameAsync(String name, ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody(this.beginDeleteByNameAsync(name), callback);
    }

    @Override
    public Observable<Void> beginDeleteByNameAsync(String name) {
        return this.client.beginDeleteAsync(name);
    }

    @Override
    public Completable deleteByIdAsync(String id) {
        return this.deleteByNameAsync(ResourceUtils.nameFromResourceId(id));
    }

    @Override
    public Observable<ResourceGroup> listAsync() {
        return this.wrapPageAsync(this.client.listAsync());
    }
}

