/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.helper.ConcurrencySemaphore;
import org.eclipse.persistence.internal.helper.ConcurrencyUtil;
import org.eclipse.persistence.internal.helper.DeferredLockManager;
import org.eclipse.persistence.internal.helper.ReadLockManager;
import org.eclipse.persistence.internal.helper.linkedlist.ExposedNodeLinkedList;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.localization.TraceLocalization;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class WriteLockManager {
    private static final Boolean ALLOW_INTERRUPTED_EXCEPTION_TO_BE_FIRED_UP_FALSE = false;
    private static final Boolean ALLOW_INTERRUPTED_EXCEPTION_TO_BE_FIRED_UP_TRUE = true;
    private static final Map<Thread, Set<ConcurrencyManager>> THREAD_TO_FAIL_TO_ACQUIRE_CACHE_KEYS = new ConcurrentHashMap<Thread, Set<ConcurrencyManager>>();
    private static final Map<Thread, Set<Object>> MAP_WRITE_LOCK_MANAGER_THREAD_TO_OBJECT_IDS_WITH_CHANGE_SET = new ConcurrentHashMap<Thread, Set<Object>>();
    private static final transient ThreadLocal<Boolean> SEMAPHORE_THREAD_LOCAL_VAR = new ThreadLocal();
    private static final transient int SEMAPHORE_MAX_NUMBER_THREADS = ConcurrencyUtil.SINGLETON.getNoOfThreadsAllowedToDoWriteLockManagerAcquireRequiredLocksInParallel();
    private static final transient Semaphore SEMAPHORE_LIMIT_MAX_NUMBER_OF_THREADS_WRITE_LOCK_MANAGER = new Semaphore(SEMAPHORE_MAX_NUMBER_THREADS);
    private transient ConcurrencySemaphore writeLockManagerSemaphore = new ConcurrencySemaphore(SEMAPHORE_THREAD_LOCAL_VAR, SEMAPHORE_MAX_NUMBER_THREADS, SEMAPHORE_LIMIT_MAX_NUMBER_OF_THREADS_WRITE_LOCK_MANAGER, this, "write_lock_manager_semaphore_acquired_01");
    public static int MAXTRIES = 10000;
    public static int MAX_WAIT = 600000;
    protected ExposedNodeLinkedList prevailingQueue = new ExposedNodeLinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map acquireLocksForClone(Object objectForClone, ClassDescriptor descriptor, CacheKey cacheKey, AbstractSession cloningSession) {
        IdentityHashMap lockedObjects;
        block17: {
            Iterator lockedList;
            long whileStartTimeMillis = System.currentTimeMillis();
            Thread currentThread = Thread.currentThread();
            DeferredLockManager lockManager = ConcurrencyManager.getDeferredLockManager(currentThread);
            ReadLockManager readLockManager = ConcurrencyManager.getReadLockManager(currentThread);
            boolean successful = false;
            lockedObjects = new IdentityHashMap();
            IdentityHashMap<Object, Object> refreshedObjects = new IdentityHashMap<Object, Object>();
            ConcurrencyManager lastCacheKeyWeNeededToWaitToAcquire = null;
            try {
                try {
                    CacheKey toWaitOn = this.acquireLockAndRelatedLocks(objectForClone, lockedObjects, refreshedObjects, cacheKey, descriptor, cloningSession);
                    int tries = 0;
                    do {
                        if (toWaitOn == null) {
                            successful = true;
                        }
                        Iterator lockedList2 = lockedObjects.values().iterator();
                        while (true) {
                            if (!lockedList2.hasNext()) {
                                StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[1];
                                lastCacheKeyWeNeededToWaitToAcquire = toWaitOn;
                                lastCacheKeyWeNeededToWaitToAcquire.putThreadAsWaitingToAcquireLockForWriting(currentThread, String.valueOf(stackTraceElement.getClassName()) + "." + stackTraceElement.getMethodName() + "(...)");
                                ConcurrencyUtil.SINGLETON.determineIfReleaseDeferredLockAppearsToBeDeadLocked(toWaitOn, whileStartTimeMillis, lockManager, readLockManager, ALLOW_INTERRUPTED_EXCEPTION_TO_BE_FIRED_UP_TRUE);
                                CacheKey cacheKey2 = toWaitOn;
                                synchronized (cacheKey2) {
                                    try {
                                        if (toWaitOn.isAcquired()) {
                                            toWaitOn.wait(ConcurrencyUtil.SINGLETON.getAcquireWaitTime());
                                        }
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    break;
                                }
                            }
                            ((CacheKey)lockedList2.next()).releaseReadLock();
                            lockedList2.remove();
                        }
                        Object waitObject = toWaitOn.getObject();
                        if (waitObject == null) continue;
                        cloningSession.checkAndRefreshInvalidObject(waitObject, toWaitOn, cloningSession.getDescriptor(waitObject));
                        refreshedObjects.put(waitObject, waitObject);
                    } while ((toWaitOn = this.acquireLockAndRelatedLocks(objectForClone, lockedObjects, refreshedObjects, cacheKey, descriptor, cloningSession)) == null || ++tries <= MAXTRIES);
                    throw ConcurrencyException.maxTriesLockOnCloneExceded(objectForClone);
                }
                catch (InterruptedException exception) {
                    throw ConcurrencyException.maxTriesLockOnCloneExceded(objectForClone);
                }
            }
            finally {
                if (lastCacheKeyWeNeededToWaitToAcquire != null) {
                    lastCacheKeyWeNeededToWaitToAcquire.removeThreadNoLongerWaitingToAcquireLockForWriting(currentThread);
                }
                if (successful) break block17;
                lockedList = lockedObjects.values().iterator();
            }
            while (lockedList.hasNext()) {
                ((CacheKey)lockedList.next()).releaseReadLock();
                lockedList.remove();
            }
        }
        return lockedObjects;
    }

    public CacheKey acquireLockAndRelatedLocks(Object objectForClone, Map lockedObjects, Map refreshedObjects, CacheKey cacheKey, ClassDescriptor descriptor, AbstractSession cloningSession) {
        if (!refreshedObjects.containsKey(objectForClone) && cloningSession.isConsideredInvalid(objectForClone, cacheKey, descriptor)) {
            return cacheKey;
        }
        if (cacheKey.acquireReadLockNoWait()) {
            if (cacheKey.getObject() == null) {
                lockedObjects.put(objectForClone, cacheKey);
            } else {
                objectForClone = cacheKey.getObject();
                if (lockedObjects.containsKey(objectForClone)) {
                    cacheKey.releaseReadLock();
                    return null;
                }
                lockedObjects.put(objectForClone, cacheKey);
            }
            return this.traverseRelatedLocks(objectForClone, lockedObjects, refreshedObjects, descriptor, cloningSession);
        }
        return cacheKey;
    }

    /*
     * Unable to fully structure code
     */
    public void transitionToDeferredLocks(MergeManager mergeManager) {
        block5: {
            try {
                if (mergeManager.isTransitionedToDeferredLocks()) {
                    return;
                }
                for (CacheKey cacheKey : mergeManager.getAcquiredLocks()) {
                    cacheKey.transitionToDeferredLock();
                }
                mergeManager.transitionToDeferredLocks();
                break block5;
            }
            catch (RuntimeException ex) {
                ** for (cacheKey : mergeManager.getAcquiredLocks())
            }
lbl-1000:
            // 1 sources

            {
                cacheKey.release();
                continue;
            }
lbl13:
            // 1 sources

            ConcurrencyManager.getDeferredLockManager(Thread.currentThread()).setIsThreadComplete(true);
            ConcurrencyManager.removeDeferredLockManager(Thread.currentThread());
            mergeManager.getAcquiredLocks().clear();
            throw ex;
        }
    }

    public CacheKey traverseRelatedLocks(Object objectForClone, Map lockedObjects, Map refreshedObjects, ClassDescriptor descriptor, AbstractSession cloningSession) {
        if (descriptor.shouldAcquireCascadedLocks()) {
            FetchGroupManager fetchGroupManager = descriptor.getFetchGroupManager();
            boolean isPartialObject = fetchGroupManager != null && fetchGroupManager.isPartialObject(objectForClone);
            for (DatabaseMapping mapping : descriptor.getLockableMappings()) {
                CacheKey toWaitOn;
                if (isPartialObject && !fetchGroupManager.isAttributeFetched(objectForClone, mapping.getAttributeName())) continue;
                Object objectToLock = mapping.getAttributeValueFromObject(objectForClone);
                if (mapping.isCollectionMapping()) {
                    if (objectToLock == null) continue;
                    ContainerPolicy cp = mapping.getContainerPolicy();
                    Object iterator = cp.iteratorFor(objectToLock);
                    while (cp.hasNext(iterator)) {
                        CacheKey toWaitOn2;
                        Object object = cp.next(iterator, cloningSession);
                        if (mapping.getReferenceDescriptor().hasWrapperPolicy()) {
                            object = mapping.getReferenceDescriptor().getWrapperPolicy().unwrapObject(object, cloningSession);
                        }
                        if ((toWaitOn2 = this.checkAndLockObject(object, lockedObjects, refreshedObjects, mapping, cloningSession)) == null) continue;
                        return toWaitOn2;
                    }
                    continue;
                }
                if (mapping.getReferenceDescriptor().hasWrapperPolicy()) {
                    objectToLock = mapping.getReferenceDescriptor().getWrapperPolicy().unwrapObject(objectToLock, cloningSession);
                }
                if ((toWaitOn = this.checkAndLockObject(objectToLock, lockedObjects, refreshedObjects, mapping, cloningSession)) == null) continue;
                return toWaitOn;
            }
        }
        return null;
    }

    public void acquireRequiredLocks(MergeManager mergeManager, UnitOfWorkChangeSet changeSet) {
        boolean semaphoreWasAcquired = false;
        boolean useSemaphore = ConcurrencyUtil.SINGLETON.isUseSemaphoreToLimitConcurrencyOnWriteLockManagerAcquireRequiredLocks();
        try {
            semaphoreWasAcquired = this.writeLockManagerSemaphore.acquireSemaphoreIfAppropriate(useSemaphore);
            this.acquireRequiredLocksInternal(mergeManager, changeSet);
        }
        finally {
            this.writeLockManagerSemaphore.releaseSemaphoreAllowOtherThreadsToStartDoingObjectBuilding(semaphoreWasAcquired);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireRequiredLocksInternal(MergeManager mergeManager, UnitOfWorkChangeSet changeSet) {
        if (!MergeManager.LOCK_ON_MERGE) {
            return;
        }
        boolean locksToAcquire = true;
        Thread currentThread = Thread.currentThread();
        long timeWhenLocksToAcquireLoopStarted = System.currentTimeMillis();
        WriteLockManager.populateMapThreadToObjectIdsWithChagenSet(currentThread, changeSet.getAllChangeSets().values());
        WriteLockManager.clearMapWriteLockManagerToCacheKeysThatCouldNotBeAcquired(currentThread);
        try {
            try {
                mergeManager.setLockThread(Thread.currentThread());
                AbstractSession session = mergeManager.getSession();
                if (session.isUnitOfWork()) {
                    session = ((UnitOfWorkImpl)session).getParent();
                }
                block20: while (locksToAcquire) {
                    locksToAcquire = false;
                    ClassDescriptor descriptor = null;
                    for (ObjectChangeSet objectChangeSet : changeSet.getAllChangeSets().values()) {
                        if (mergeManager.shouldMergeChangesIntoDistributedCache() && objectChangeSet.getSynchronizationType() == 2 || objectChangeSet.getId() == null) continue;
                        descriptor = objectChangeSet.getDescriptor();
                        if (descriptor == null) {
                            descriptor = session.getDescriptor(objectChangeSet.getClassType(session));
                            objectChangeSet.setDescriptor(descriptor);
                        }
                        if (descriptor.getCachePolicy().shouldIsolateObjectsInUnitOfWork()) continue;
                        AbstractSession targetSession = session.getParentIdentityMapSession(descriptor, true, true);
                        CacheKey activeCacheKey = this.attemptToAcquireLock(descriptor, objectChangeSet.getId(), targetSession);
                        if (activeCacheKey == null) {
                            if (this.prevailingQueue.getFirst() == mergeManager) {
                                activeCacheKey = this.waitOnObjectLock(descriptor, objectChangeSet.getId(), targetSession, (int)Math.round((0.001 + Math.random()) * 500.0));
                            }
                            if (activeCacheKey == null) {
                                block38: {
                                    Object[] params;
                                    this.releaseAllAcquiredLocks(mergeManager);
                                    activeCacheKey = targetSession.getIdentityMapAccessorInstance().getCacheKeyForObjectForLock(objectChangeSet.getId(), descriptor.getJavaClass(), descriptor);
                                    if (session.shouldLog(2, "cache")) {
                                        params = new Object[]{descriptor.getJavaClass(), objectChangeSet.getId(), Thread.currentThread().getName()};
                                        session.log(2, "cache", "dead_lock_encountered_on_write_no_cachekey", params, null);
                                    }
                                    if (mergeManager.getWriteLockQueued() == null) {
                                        params = this.prevailingQueue;
                                        synchronized (params) {
                                            mergeManager.setQueueNode(this.prevailingQueue.addLast(mergeManager));
                                        }
                                    }
                                    mergeManager.setWriteLockQueued(objectChangeSet.getId());
                                    try {
                                        if (activeCacheKey == null) break block38;
                                        params = activeCacheKey;
                                        synchronized (params) {
                                            if (activeCacheKey.isAcquired() && activeCacheKey.getActiveThread() != Thread.currentThread()) {
                                                Thread thread = activeCacheKey.getActiveThread();
                                                if (thread.isAlive()) {
                                                    long time = System.currentTimeMillis();
                                                    activeCacheKey.wait(MAX_WAIT);
                                                    if (System.currentTimeMillis() - time >= (long)MAX_WAIT) {
                                                        StackTraceElement[] trace;
                                                        Object[] params2 = new Object[]{MAX_WAIT / 1000, descriptor.getJavaClassName(), activeCacheKey.getKey(), thread.getName()};
                                                        StringBuilder buffer = new StringBuilder(TraceLocalization.buildMessage("max_time_exceeded_for_acquirerequiredlocks_wait", params2));
                                                        StackTraceElement[] stackTraceElementArray = trace = thread.getStackTrace();
                                                        int n = trace.length;
                                                        int n2 = 0;
                                                        while (n2 < n) {
                                                            StackTraceElement element = stackTraceElementArray[n2];
                                                            buffer.append("\t\tat");
                                                            buffer.append(element.toString());
                                                            buffer.append("\n");
                                                            ++n2;
                                                        }
                                                        session.log(7, "cache", buffer.toString());
                                                        session.getIdentityMapAccessor().printIdentityMapLocks();
                                                    }
                                                } else {
                                                    session.log(7, "cache", "releasing_invalid_lock", new Object[]{thread.getName(), descriptor.getJavaClass(), objectChangeSet.getId()});
                                                    while (activeCacheKey.isAcquired()) {
                                                        activeCacheKey.release();
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    catch (InterruptedException exception) {
                                        throw ConcurrencyException.waitWasInterrupted(exception.getMessage());
                                    }
                                }
                                WriteLockManager.addCacheKeyToMapWriteLockManagerToCacheKeysThatCouldNotBeAcquired(currentThread, activeCacheKey, timeWhenLocksToAcquireLoopStarted);
                                locksToAcquire = true;
                                continue block20;
                            }
                            WriteLockManager.removeCacheKeyFromMapWriteLockManagerToCacheKeysThatCouldNotBeAcquired(currentThread, activeCacheKey);
                            objectChangeSet.setActiveCacheKey(activeCacheKey);
                            mergeManager.getAcquiredLocks().add(activeCacheKey);
                            continue;
                        }
                        WriteLockManager.removeCacheKeyFromMapWriteLockManagerToCacheKeysThatCouldNotBeAcquired(currentThread, activeCacheKey);
                        objectChangeSet.setActiveCacheKey(activeCacheKey);
                        mergeManager.getAcquiredLocks().add(activeCacheKey);
                    }
                }
            }
            catch (RuntimeException exception) {
                this.releaseAllAcquiredLocks(mergeManager);
                throw exception;
            }
            catch (InterruptedException exception) {
                this.releaseAllAcquiredLocks(mergeManager);
                throw ConcurrencyException.waitFailureOnClientSession(exception);
            }
            catch (Error error) {
                this.releaseAllAcquiredLocks(mergeManager);
                mergeManager.getSession().logThrowable(7, "transaction", error);
                throw error;
            }
        }
        catch (Throwable throwable) {
            if (mergeManager.getWriteLockQueued() != null) {
                ExposedNodeLinkedList exposedNodeLinkedList = this.prevailingQueue;
                synchronized (exposedNodeLinkedList) {
                    this.prevailingQueue.remove(mergeManager.getQueueNode());
                }
                mergeManager.setWriteLockQueued(null);
            }
            WriteLockManager.clearMapWriteLockManagerToCacheKeysThatCouldNotBeAcquired(currentThread);
            WriteLockManager.clearMapThreadToObjectIdsWithChagenSet(currentThread);
            throw throwable;
        }
        if (mergeManager.getWriteLockQueued() != null) {
            ExposedNodeLinkedList exposedNodeLinkedList = this.prevailingQueue;
            synchronized (exposedNodeLinkedList) {
                this.prevailingQueue.remove(mergeManager.getQueueNode());
            }
            mergeManager.setWriteLockQueued(null);
        }
        WriteLockManager.clearMapWriteLockManagerToCacheKeysThatCouldNotBeAcquired(currentThread);
        WriteLockManager.clearMapThreadToObjectIdsWithChagenSet(currentThread);
    }

    public CacheKey appendLock(Object primaryKey, Object objectToLock, ClassDescriptor descriptor, MergeManager mergeManager, AbstractSession session) {
        CacheKey lockedCacheKey = session.getIdentityMapAccessorInstance().acquireLockNoWait(primaryKey, descriptor.getJavaClass(), false, descriptor);
        if (lockedCacheKey == null) {
            session.getIdentityMapAccessorInstance().getWriteLockManager().transitionToDeferredLocks(mergeManager);
            lockedCacheKey = session.getIdentityMapAccessorInstance().acquireDeferredLock(primaryKey, descriptor.getJavaClass(), descriptor, true);
            Object cachedObject = lockedCacheKey.getObject();
            if (cachedObject == null) {
                if (lockedCacheKey.getActiveThread() == Thread.currentThread()) {
                    lockedCacheKey.setObject(objectToLock);
                } else {
                    cachedObject = lockedCacheKey.waitForObject();
                }
            }
            lockedCacheKey.releaseDeferredLock();
            return lockedCacheKey;
        }
        if (lockedCacheKey.getObject() == null) {
            lockedCacheKey.setObject(objectToLock);
        }
        if (mergeManager.isTransitionedToDeferredLocks()) {
            CacheKey.getDeferredLockManager(Thread.currentThread()).getActiveLocks().add(lockedCacheKey);
        } else {
            mergeManager.getAcquiredLocks().add(lockedCacheKey);
        }
        return lockedCacheKey;
    }

    protected CacheKey attemptToAcquireLock(ClassDescriptor descriptor, Object primaryKey, AbstractSession session) {
        return session.getIdentityMapAccessorInstance().acquireLockNoWait(primaryKey, descriptor.getJavaClass(), true, descriptor);
    }

    protected CacheKey checkAndLockObject(Object objectToLock, Map lockedObjects, Map refreshedObjects, DatabaseMapping mapping, AbstractSession cloningSession) {
        if (objectToLock != null && !lockedObjects.containsKey(objectToLock)) {
            Object primaryKeyToLock = null;
            ClassDescriptor referenceDescriptor = null;
            referenceDescriptor = mapping.getReferenceDescriptor().hasInheritance() || mapping.getReferenceDescriptor().isDescriptorForInterface() ? cloningSession.getDescriptor(objectToLock) : mapping.getReferenceDescriptor();
            if (referenceDescriptor.isDescriptorTypeAggregate()) {
                this.traverseRelatedLocks(objectToLock, lockedObjects, refreshedObjects, referenceDescriptor, cloningSession);
            } else {
                CacheKey toWaitOn;
                primaryKeyToLock = referenceDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(objectToLock, cloningSession);
                CacheKey cacheKey = cloningSession.getIdentityMapAccessorInstance().getCacheKeyForObjectForLock(primaryKeyToLock, objectToLock.getClass(), referenceDescriptor);
                if (cacheKey == null) {
                    cacheKey = new CacheKey(primaryKeyToLock);
                    cacheKey.setReadTime(System.currentTimeMillis());
                }
                if ((toWaitOn = this.acquireLockAndRelatedLocks(objectToLock, lockedObjects, refreshedObjects, cacheKey, referenceDescriptor, cloningSession)) != null) {
                    return toWaitOn;
                }
            }
        }
        return null;
    }

    public void releaseAllAcquiredLocks(MergeManager mergeManager) {
        if (!MergeManager.LOCK_ON_MERGE) {
            return;
        }
        ArrayList<CacheKey> acquiredLocks = mergeManager.getAcquiredLocks();
        Iterator locks = acquiredLocks.iterator();
        RuntimeException exception = null;
        while (locks.hasNext()) {
            try {
                CacheKey cacheKeyToRemove = (CacheKey)locks.next();
                if (cacheKeyToRemove.getObject() == null) {
                    cacheKeyToRemove.removeFromOwningMap();
                }
                if (mergeManager.isTransitionedToDeferredLocks()) {
                    cacheKeyToRemove.releaseDeferredLock();
                    continue;
                }
                cacheKeyToRemove.release();
            }
            catch (RuntimeException e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        acquiredLocks.clear();
        if (exception != null) {
            throw exception;
        }
    }

    protected CacheKey waitOnObjectLock(ClassDescriptor descriptor, Object primaryKey, AbstractSession session, int waitTime) {
        return session.getIdentityMapAccessorInstance().acquireLockWithWait(primaryKey, descriptor.getJavaClass(), true, descriptor, waitTime);
    }

    public static Map<Thread, Set<ConcurrencyManager>> getThreadToFailToAcquireCacheKeys() {
        return Collections.unmodifiableMap(THREAD_TO_FAIL_TO_ACQUIRE_CACHE_KEYS);
    }

    public static Map<Thread, Set<Object>> getMapWriteLockManagerThreadToObjectIdsWithChangeSet() {
        return Collections.unmodifiableMap(MAP_WRITE_LOCK_MANAGER_THREAD_TO_OBJECT_IDS_WITH_CHANGE_SET);
    }

    public static void clearMapThreadToObjectIdsWithChagenSet(Thread thread) {
        MAP_WRITE_LOCK_MANAGER_THREAD_TO_OBJECT_IDS_WITH_CHANGE_SET.remove(thread);
    }

    public static void populateMapThreadToObjectIdsWithChagenSet(Thread thread, Collection<ObjectChangeSet> objectChangeSets) {
        Set<Object> value;
        boolean hasKey = MAP_WRITE_LOCK_MANAGER_THREAD_TO_OBJECT_IDS_WITH_CHANGE_SET.containsKey(thread);
        if (!hasKey && (value = MAP_WRITE_LOCK_MANAGER_THREAD_TO_OBJECT_IDS_WITH_CHANGE_SET.get(thread)) == null) {
            MAP_WRITE_LOCK_MANAGER_THREAD_TO_OBJECT_IDS_WITH_CHANGE_SET.put(thread, new HashSet());
        }
        Set<Object> primarykeys = MAP_WRITE_LOCK_MANAGER_THREAD_TO_OBJECT_IDS_WITH_CHANGE_SET.get(thread);
        primarykeys.clear();
        for (ObjectChangeSet objectChangeSet : objectChangeSets) {
            Object primaryKey = objectChangeSet.getId();
            primarykeys.add(primaryKey);
        }
    }

    public static void clearMapWriteLockManagerToCacheKeysThatCouldNotBeAcquired(Thread thread) {
        THREAD_TO_FAIL_TO_ACQUIRE_CACHE_KEYS.remove(thread);
    }

    public static void addCacheKeyToMapWriteLockManagerToCacheKeysThatCouldNotBeAcquired(Thread thread, ConcurrencyManager cacheKeyThatCouldNotBeAcquired, long whileStartDate) throws InterruptedException {
        if (cacheKeyThatCouldNotBeAcquired == null) {
            return;
        }
        Set<ConcurrencyManager> cacheKeysWeAreHavingDifficultyAcquiring = WriteLockManager.getCacheKeysThatCouldNotBeAcquiredByThread(thread);
        if (!cacheKeysWeAreHavingDifficultyAcquiring.contains(cacheKeyThatCouldNotBeAcquired)) {
            cacheKeysWeAreHavingDifficultyAcquiring.add(cacheKeyThatCouldNotBeAcquired);
        }
        Thread currentThread = Thread.currentThread();
        DeferredLockManager lockManager = ConcurrencyManager.getDeferredLockManager(currentThread);
        ReadLockManager readLockManager = ConcurrencyManager.getReadLockManager(currentThread);
        ConcurrencyUtil.SINGLETON.determineIfReleaseDeferredLockAppearsToBeDeadLocked(cacheKeyThatCouldNotBeAcquired, whileStartDate, lockManager, readLockManager, ALLOW_INTERRUPTED_EXCEPTION_TO_BE_FIRED_UP_FALSE);
    }

    public static void removeCacheKeyFromMapWriteLockManagerToCacheKeysThatCouldNotBeAcquired(Thread thread, ConcurrencyManager cacheKeyThatCouldNotBeAcquired) {
        Set<ConcurrencyManager> cacheKeysWeAreHavingDifficultyAcquiring = WriteLockManager.getCacheKeysThatCouldNotBeAcquiredByThread(thread);
        cacheKeysWeAreHavingDifficultyAcquiring.remove(cacheKeyThatCouldNotBeAcquired);
    }

    private static Set<ConcurrencyManager> getCacheKeysThatCouldNotBeAcquiredByThread(Thread thread) {
        Set<ConcurrencyManager> value;
        boolean hasKey = THREAD_TO_FAIL_TO_ACQUIRE_CACHE_KEYS.containsKey(thread);
        if (!hasKey && (value = THREAD_TO_FAIL_TO_ACQUIRE_CACHE_KEYS.get(thread)) == null) {
            THREAD_TO_FAIL_TO_ACQUIRE_CACHE_KEYS.put(thread, new HashSet());
        }
        return THREAD_TO_FAIL_TO_ACQUIRE_CACHE_KEYS.get(thread);
    }
}

