/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.containerregistry.RegistryTaskRun;
import com.microsoft.azure.management.containerregistry.RegistryTaskRuns;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManagementClientImpl;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManager;
import com.microsoft.azure.management.containerregistry.implementation.RegistryTaskRunImpl;
import com.microsoft.azure.management.containerregistry.implementation.RunGetLogResultInner;
import com.microsoft.azure.management.containerregistry.implementation.RunInner;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class RegistryTaskRunsImpl
implements RegistryTaskRuns {
    private ContainerRegistryManager registryManager;

    RegistryTaskRunsImpl(ContainerRegistryManager registryManager) {
        this.registryManager = registryManager;
    }

    @Override
    public RegistryTaskRun.DefinitionStages.BlankFromRuns scheduleRun() {
        return new RegistryTaskRunImpl(this.registryManager, new RunInner());
    }

    @Override
    public Observable<RegistryTaskRun> listByRegistryAsync(String rgName, String acrName) {
        return ((ContainerRegistryManagementClientImpl)((Object)this.registryManager.inner())).runs().listAsync(rgName, acrName).flatMapIterable((Func1)new Func1<Page<RunInner>, Iterable<RunInner>>(){

            public Iterable<RunInner> call(Page<RunInner> page) {
                return page.items();
            }
        }).map((Func1)new Func1<RunInner, RegistryTaskRun>(){

            public RegistryTaskRun call(RunInner inner) {
                return RegistryTaskRunsImpl.this.wrapModel(inner);
            }
        });
    }

    @Override
    public PagedList<RegistryTaskRun> listByRegistry(String rgName, String acrName) {
        return new PagedListConverter<RunInner, RegistryTaskRun>(){

            public Observable<RegistryTaskRun> typeConvertAsync(RunInner inner) {
                return Observable.just((Object)RegistryTaskRunsImpl.this.wrapModel(inner));
            }
        }.convert(((ContainerRegistryManagementClientImpl)((Object)this.registryManager.inner())).runs().list(rgName, acrName));
    }

    @Override
    public Observable<String> getLogSasUrlAsync(String rgName, String acrName, String runId) {
        return ((ContainerRegistryManagementClientImpl)((Object)this.registryManager.inner())).runs().getLogSasUrlAsync(rgName, acrName, runId).map((Func1)new Func1<RunGetLogResultInner, String>(){

            public String call(RunGetLogResultInner runGetLogResultInner) {
                return runGetLogResultInner.logLink();
            }
        });
    }

    @Override
    public String getLogSasUrl(String rgName, String acrName, String runId) {
        return (String)this.getLogSasUrlAsync(rgName, acrName, runId).toBlocking().last();
    }

    @Override
    public Completable cancelAsync(String rgName, String acrName, String runId) {
        return ((ContainerRegistryManagementClientImpl)((Object)this.registryManager.inner())).runs().cancelAsync(rgName, acrName, runId).toCompletable();
    }

    @Override
    public void cancel(String rgName, String acrName, String runId) {
        this.cancelAsync(rgName, acrName, runId).await();
    }

    private RegistryTaskRunImpl wrapModel(RunInner innerModel) {
        return new RegistryTaskRunImpl(this.registryManager, innerModel);
    }
}

