/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.token;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public class Tokens {
    private final AccessToken accessToken;
    private final RefreshToken refreshToken;

    public Tokens(AccessToken accessToken, RefreshToken refreshToken) {
        if (accessToken == null) {
            throw new IllegalArgumentException("The access token must not be null");
        }
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public BearerAccessToken getBearerAccessToken() {
        if (this.accessToken instanceof BearerAccessToken) {
            return (BearerAccessToken)this.accessToken;
        }
        return null;
    }

    public RefreshToken getRefreshToken() {
        return this.refreshToken;
    }

    public Set<String> getParameterNames() {
        Set<String> paramNames = this.accessToken.getParameterNames();
        if (this.refreshToken != null) {
            paramNames.addAll(this.refreshToken.getParameterNames());
        }
        return paramNames;
    }

    public JSONObject toJSONObject() {
        JSONObject o = this.accessToken.toJSONObject();
        if (this.refreshToken != null) {
            o.putAll((Map)this.refreshToken.toJSONObject());
        }
        return o;
    }

    public String toString() {
        return this.toJSONObject().toJSONString();
    }

    public static Tokens parse(JSONObject jsonObject) throws ParseException {
        return new Tokens(AccessToken.parse(jsonObject), RefreshToken.parse(jsonObject));
    }
}

