/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.VirtualMachineImage;
import com.microsoft.azure.management.compute.VirtualMachineImages;
import com.microsoft.azure.management.compute.VirtualMachineOffer;
import com.microsoft.azure.management.compute.VirtualMachinePublisher;
import com.microsoft.azure.management.compute.VirtualMachinePublishers;
import com.microsoft.azure.management.compute.VirtualMachineSku;
import com.microsoft.azure.management.compute.implementation.ChildListFlattener;
import com.microsoft.azure.management.compute.implementation.VirtualMachineImageImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineImageInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineImageResourceInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineImagesInner;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class VirtualMachineImagesImpl
implements VirtualMachineImages {
    private final VirtualMachinePublishers publishers;
    private final VirtualMachineImagesInner client;

    VirtualMachineImagesImpl(VirtualMachinePublishers publishers, VirtualMachineImagesInner client) {
        this.publishers = publishers;
        this.client = client;
    }

    @Override
    public VirtualMachineImage getImage(Region region, String publisherName, String offerName, String skuName, String version) {
        VirtualMachineImageInner innerImage;
        List<VirtualMachineImageResourceInner> innerImages;
        if (version.equalsIgnoreCase("latest") && (innerImages = this.client.list(region.name(), publisherName, offerName, skuName, null, 1, "name desc")) != null && !innerImages.isEmpty()) {
            VirtualMachineImageResourceInner innerImageResource = innerImages.get(0);
            version = innerImageResource.name();
        }
        return (innerImage = this.client.get(region.name(), publisherName, offerName, skuName, version)) != null ? new VirtualMachineImageImpl(region, publisherName, offerName, skuName, version, innerImage) : null;
    }

    @Override
    public VirtualMachineImage getImage(String region, String publisherName, String offerName, String skuName, String version) {
        VirtualMachineImageInner innerImage;
        List<VirtualMachineImageResourceInner> innerImages;
        if (version.equalsIgnoreCase("latest") && (innerImages = this.client.list(region, publisherName, offerName, skuName, null, 1, "name desc")) != null && !innerImages.isEmpty()) {
            VirtualMachineImageResourceInner innerImageResource = innerImages.get(0);
            version = innerImageResource.name();
        }
        return (innerImage = this.client.get(region, publisherName, offerName, skuName, version)) != null ? new VirtualMachineImageImpl(Region.fromName((String)region), publisherName, offerName, skuName, version, innerImage) : null;
    }

    public PagedList<VirtualMachineImage> listByRegion(Region location) {
        return this.listByRegion(location.toString());
    }

    public PagedList<VirtualMachineImage> listByRegion(String regionName) {
        PagedList publishers = this.publishers().listByRegion(regionName);
        PagedList<VirtualMachineOffer> offers = new ChildListFlattener<VirtualMachinePublisher, VirtualMachineOffer>(publishers, new ChildListFlattener.ChildListLoader<VirtualMachinePublisher, VirtualMachineOffer>(){

            @Override
            public PagedList<VirtualMachineOffer> loadList(VirtualMachinePublisher publisher) {
                return publisher.offers().list();
            }
        }).flatten();
        PagedList<VirtualMachineSku> skus = new ChildListFlattener<VirtualMachineOffer, VirtualMachineSku>(offers, new ChildListFlattener.ChildListLoader<VirtualMachineOffer, VirtualMachineSku>(){

            @Override
            public PagedList<VirtualMachineSku> loadList(VirtualMachineOffer offer) {
                return offer.skus().list();
            }
        }).flatten();
        PagedList<VirtualMachineImage> images = new ChildListFlattener<VirtualMachineSku, VirtualMachineImage>(skus, new ChildListFlattener.ChildListLoader<VirtualMachineSku, VirtualMachineImage>(){

            @Override
            public PagedList<VirtualMachineImage> loadList(VirtualMachineSku sku) {
                return sku.images().list();
            }
        }).flatten();
        return images;
    }

    public Observable<VirtualMachineImage> listByRegionAsync(Region region) {
        return this.listByRegionAsync(region.name());
    }

    public Observable<VirtualMachineImage> listByRegionAsync(String regionName) {
        return this.publishers().listByRegionAsync(regionName).flatMap((Func1)new Func1<VirtualMachinePublisher, Observable<VirtualMachineOffer>>(){

            public Observable<VirtualMachineOffer> call(VirtualMachinePublisher virtualMachinePublisher) {
                return virtualMachinePublisher.offers().listAsync();
            }
        }).flatMap((Func1)new Func1<VirtualMachineOffer, Observable<VirtualMachineSku>>(){

            public Observable<VirtualMachineSku> call(VirtualMachineOffer virtualMachineExtensionImageType) {
                return virtualMachineExtensionImageType.skus().listAsync();
            }
        }).flatMap((Func1)new Func1<VirtualMachineSku, Observable<VirtualMachineImage>>(){

            public Observable<VirtualMachineImage> call(VirtualMachineSku virtualMachineSku) {
                return virtualMachineSku.images().listAsync();
            }
        });
    }

    @Override
    public VirtualMachinePublishers publishers() {
        return this.publishers;
    }
}

