/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.GalleryImageInner;
import com.microsoft.azure.management.compute.implementation.PageImpl1;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class GalleryImagesInner {
    private GalleryImagesService service;
    private ComputeManagementClientImpl client;

    public GalleryImagesInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = (GalleryImagesService)retrofit.create(GalleryImagesService.class);
        this.client = client;
    }

    public GalleryImageInner createOrUpdate(String resourceGroupName, String galleryName, String galleryImageName, GalleryImageInner galleryImage) {
        return (GalleryImageInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImage).toBlocking().last()).body());
    }

    public ServiceFuture<GalleryImageInner> createOrUpdateAsync(String resourceGroupName, String galleryName, String galleryImageName, GalleryImageInner galleryImage, ServiceCallback<GalleryImageInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImage), serviceCallback);
    }

    public Observable<GalleryImageInner> createOrUpdateAsync(String resourceGroupName, String galleryName, String galleryImageName, GalleryImageInner galleryImage) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImage).map((Func1)new Func1<ServiceResponse<GalleryImageInner>, GalleryImageInner>(){

            public GalleryImageInner call(ServiceResponse<GalleryImageInner> response) {
                return (GalleryImageInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GalleryImageInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryImageName, GalleryImageInner galleryImage) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryImageName == null) {
            throw new IllegalArgumentException("Parameter galleryImageName is required and cannot be null.");
        }
        if (galleryImage == null) {
            throw new IllegalArgumentException("Parameter galleryImage is required and cannot be null.");
        }
        Validator.validate((Object)((Object)galleryImage));
        String apiVersion = "2018-06-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, galleryName, galleryImageName, "2018-06-01", galleryImage, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<GalleryImageInner>(){}.getType());
    }

    public GalleryImageInner beginCreateOrUpdate(String resourceGroupName, String galleryName, String galleryImageName, GalleryImageInner galleryImage) {
        return (GalleryImageInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImage).toBlocking().single()).body());
    }

    public ServiceFuture<GalleryImageInner> beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String galleryImageName, GalleryImageInner galleryImage, ServiceCallback<GalleryImageInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImage), serviceCallback);
    }

    public Observable<GalleryImageInner> beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String galleryImageName, GalleryImageInner galleryImage) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImage).map((Func1)new Func1<ServiceResponse<GalleryImageInner>, GalleryImageInner>(){

            public GalleryImageInner call(ServiceResponse<GalleryImageInner> response) {
                return (GalleryImageInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GalleryImageInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryImageName, GalleryImageInner galleryImage) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryImageName == null) {
            throw new IllegalArgumentException("Parameter galleryImageName is required and cannot be null.");
        }
        if (galleryImage == null) {
            throw new IllegalArgumentException("Parameter galleryImage is required and cannot be null.");
        }
        Validator.validate((Object)((Object)galleryImage));
        String apiVersion = "2018-06-01";
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, galleryName, galleryImageName, "2018-06-01", galleryImage, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GalleryImageInner>>>(){

            public Observable<ServiceResponse<GalleryImageInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GalleryImagesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GalleryImageInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GalleryImageInner>(){}.getType()).register(201, new TypeToken<GalleryImageInner>(){}.getType()).register(202, new TypeToken<GalleryImageInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public GalleryImageInner get(String resourceGroupName, String galleryName, String galleryImageName) {
        return (GalleryImageInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName).toBlocking().single()).body());
    }

    public ServiceFuture<GalleryImageInner> getAsync(String resourceGroupName, String galleryName, String galleryImageName, ServiceCallback<GalleryImageInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName), serviceCallback);
    }

    public Observable<GalleryImageInner> getAsync(String resourceGroupName, String galleryName, String galleryImageName) {
        return this.getWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName).map((Func1)new Func1<ServiceResponse<GalleryImageInner>, GalleryImageInner>(){

            public GalleryImageInner call(ServiceResponse<GalleryImageInner> response) {
                return (GalleryImageInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GalleryImageInner>> getWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryImageName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryImageName == null) {
            throw new IllegalArgumentException("Parameter galleryImageName is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, galleryName, galleryImageName, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GalleryImageInner>>>(){

            public Observable<ServiceResponse<GalleryImageInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GalleryImagesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GalleryImageInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GalleryImageInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String galleryName, String galleryImageName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String galleryName, String galleryImageName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String galleryName, String galleryImageName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryImageName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryImageName == null) {
            throw new IllegalArgumentException("Parameter galleryImageName is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, galleryName, galleryImageName, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String galleryName, String galleryImageName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String galleryName, String galleryImageName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String galleryName, String galleryImageName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryImageName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryImageName == null) {
            throw new IllegalArgumentException("Parameter galleryImageName is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, galleryName, galleryImageName, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GalleryImagesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<GalleryImageInner> listByGallery(String resourceGroupName, String galleryName) {
        ServiceResponse response = (ServiceResponse)this.listByGallerySinglePageAsync(resourceGroupName, galleryName).toBlocking().single();
        return new PagedList<GalleryImageInner>((Page)response.body()){

            public Page<GalleryImageInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)GalleryImagesInner.this.listByGalleryNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<GalleryImageInner>> listByGalleryAsync(String resourceGroupName, String galleryName, ListOperationCallback<GalleryImageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByGallerySinglePageAsync(resourceGroupName, galleryName), (Func1)new Func1<String, Observable<ServiceResponse<Page<GalleryImageInner>>>>(){

            public Observable<ServiceResponse<Page<GalleryImageInner>>> call(String nextPageLink) {
                return GalleryImagesInner.this.listByGalleryNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<GalleryImageInner>> listByGalleryAsync(String resourceGroupName, String galleryName) {
        return this.listByGalleryWithServiceResponseAsync(resourceGroupName, galleryName).map((Func1)new Func1<ServiceResponse<Page<GalleryImageInner>>, Page<GalleryImageInner>>(){

            public Page<GalleryImageInner> call(ServiceResponse<Page<GalleryImageInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<GalleryImageInner>>> listByGalleryWithServiceResponseAsync(String resourceGroupName, String galleryName) {
        return this.listByGallerySinglePageAsync(resourceGroupName, galleryName).concatMap((Func1)new Func1<ServiceResponse<Page<GalleryImageInner>>, Observable<ServiceResponse<Page<GalleryImageInner>>>>(){

            public Observable<ServiceResponse<Page<GalleryImageInner>>> call(ServiceResponse<Page<GalleryImageInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(GalleryImagesInner.this.listByGalleryNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<GalleryImageInner>>> listByGallerySinglePageAsync(String resourceGroupName, String galleryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.listByGallery(this.client.subscriptionId(), resourceGroupName, galleryName, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GalleryImageInner>>>>(){

            public Observable<ServiceResponse<Page<GalleryImageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = GalleryImagesInner.this.listByGalleryDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<GalleryImageInner>> listByGalleryDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<GalleryImageInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<GalleryImageInner> listByGalleryNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByGalleryNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<GalleryImageInner>((Page)response.body()){

            public Page<GalleryImageInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)GalleryImagesInner.this.listByGalleryNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<GalleryImageInner>> listByGalleryNextAsync(String nextPageLink, ServiceFuture<List<GalleryImageInner>> serviceFuture, ListOperationCallback<GalleryImageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByGalleryNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<GalleryImageInner>>>>(){

            public Observable<ServiceResponse<Page<GalleryImageInner>>> call(String nextPageLink) {
                return GalleryImagesInner.this.listByGalleryNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<GalleryImageInner>> listByGalleryNextAsync(String nextPageLink) {
        return this.listByGalleryNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<GalleryImageInner>>, Page<GalleryImageInner>>(){

            public Page<GalleryImageInner> call(ServiceResponse<Page<GalleryImageInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<GalleryImageInner>>> listByGalleryNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByGalleryNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<GalleryImageInner>>, Observable<ServiceResponse<Page<GalleryImageInner>>>>(){

            public Observable<ServiceResponse<Page<GalleryImageInner>>> call(ServiceResponse<Page<GalleryImageInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(GalleryImagesInner.this.listByGalleryNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<GalleryImageInner>>> listByGalleryNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByGalleryNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GalleryImageInner>>>>(){

            public Observable<ServiceResponse<Page<GalleryImageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = GalleryImagesInner.this.listByGalleryNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<GalleryImageInner>> listByGalleryNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<GalleryImageInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface GalleryImagesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryImages createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Path(value="galleryImageName") String var4, @Query(value="api-version") String var5, @Body GalleryImageInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryImages beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Path(value="galleryImageName") String var4, @Query(value="api-version") String var5, @Body GalleryImageInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryImages get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Path(value="galleryImageName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryImages delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Path(value="galleryImageName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryImages beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Path(value="galleryImageName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryImages listByGallery"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images")
        public Observable<Response<ResponseBody>> listByGallery(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryImages listByGalleryNext"})
        @GET
        public Observable<Response<ResponseBody>> listByGalleryNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

