/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandHandlerUtility {
    public static final Logger LOG = LoggerFactory.getLogger(CommandHandlerUtility.class);
    private static final String SHELL_CMD = "/bin/sh";
    private static final String SHELL_CMD_OPTION = "-c";
    private static final String FIND_PROCESS_ID_CMD_FORMAT = "lsof -i:%s | tail -n 1 | tr -s ' ' | cut -d' ' -f2";
    private static final String KILL_PROCESS_CMD_FORMAT = "kill %s %s";
    private static final int SLEEP_AFTER_SOFT_KILL_IN_MS = 4000;

    public static void tryKillingProcessUsingPort(int port, boolean forceKill) {
        String processID = CommandHandlerUtility.findProcessIdUsingPort(port);
        CommandHandlerUtility.sendKillToPID(processID, forceKill);
    }

    private static String findProcessIdUsingPort(int port) {
        String retPID = "";
        String[] cmd = new String[]{SHELL_CMD, SHELL_CMD_OPTION, String.format(FIND_PROCESS_ID_CMD_FORMAT, port)};
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            retPID = new BufferedReader(new InputStreamReader(p.getInputStream())).lines().collect(Collectors.joining("\n"));
            if (StringUtils.isEmpty((CharSequence)retPID)) {
                String errorMsg = new BufferedReader(new InputStreamReader(p.getErrorStream())).lines().collect(Collectors.joining("\n"));
                throw new IOException(errorMsg);
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to get process ID which uses the port{}", (Object)port, (Object)e);
        }
        return retPID;
    }

    private static void sendKillToPID(String pid, boolean forceKill) {
        if (StringUtils.isBlank((CharSequence)pid)) {
            return;
        }
        String cmd = String.format(KILL_PROCESS_CMD_FORMAT, forceKill ? "-9 " : "", pid);
        try {
            Runtime.getRuntime().exec(cmd);
            if (!forceKill) {
                LOG.info("Sleeping for {} milliseconds after soft kill", (Object)4000);
                Thread.sleep(4000L);
            }
        }
        catch (IOException | InterruptedException e) {
            LOG.warn("Failed to kill the process {} which uses the port with hard kill flag{}", new Object[]{pid, forceKill, e});
        }
    }
}

