/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.tagsync.source.atlas;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.tagsync.source.atlas.AtlasResourceMapper;
import org.apache.ranger.tagsync.source.atlasrest.RangerAtlasEntity;

public class AtlasAdlsResourceMapper
extends AtlasResourceMapper {
    public static final String ENTITY_TYPE_ADLS_GEN2_ACCOUNT = "adls_gen2_account";
    public static final String ENTITY_TYPE_ADLS_GEN2_CONTAINER = "adls_gen2_container";
    public static final String ENTITY_TYPE_ADLS_GEN2_DIRECTORY = "adls_gen2_directory";
    public static final String RANGER_TYPE_ADLS_GEN2_ACCOUNT = "storageaccount";
    public static final String RANGER_TYPE_ADLS_GEN2_CONTAINER = "container";
    public static final String RANGER_TYPE_ADLS_GEN2_RELATIVE_PATH = "relativepath";
    public static final String[] SUPPORTED_ENTITY_TYPES = new String[]{"adls_gen2_account", "adls_gen2_container", "adls_gen2_directory"};
    private static final String SEP_PROTOCOL = "://";
    private static final String SEP_CONTAINER = "@";
    private static final String SEP_RELATIVE_PATH = "/";
    private static final int IDX_RESOURCE_ACCOUNT = 0;
    private static final int IDX_RESOURCE_CONTAINER = 1;
    private static final int IDX_RESOURCE_RELATIVE_PATH = 2;
    private static final int IDX_CLUSTER_NAME = 3;
    private static final int RESOURCE_COUNT = 4;

    public AtlasAdlsResourceMapper() {
        super("adls", SUPPORTED_ENTITY_TYPES);
    }

    @Override
    public RangerServiceResource buildResource(RangerAtlasEntity entity) throws Exception {
        String containerName;
        String qualifiedName = (String)entity.getAttributes().get("qualifiedName");
        if (StringUtils.isEmpty((String)qualifiedName)) {
            throw new Exception("attribute 'qualifiedName' not found in entity");
        }
        String[] resources = this.parseQualifiedName(qualifiedName);
        String clusterName = resources[3];
        String accountName = resources[0];
        if (StringUtils.isEmpty((String)clusterName)) {
            this.throwExceptionWithMessage("cluster-name not found in attribute 'qualifiedName': " + qualifiedName);
        }
        if (StringUtils.isEmpty((String)accountName)) {
            this.throwExceptionWithMessage("account-name not found in attribute 'qualifiedName': " + qualifiedName);
        }
        String entityType = entity.getTypeName();
        String entityGuid = entity.getGuid();
        String serviceName = this.getRangerServiceName(clusterName);
        HashMap<String, RangerPolicy.RangerPolicyResource> elements = new HashMap<String, RangerPolicy.RangerPolicyResource>();
        if (StringUtils.equals((String)entityType, (String)ENTITY_TYPE_ADLS_GEN2_ACCOUNT)) {
            elements.put(RANGER_TYPE_ADLS_GEN2_ACCOUNT, new RangerPolicy.RangerPolicyResource(accountName));
        } else if (StringUtils.equals((String)entityType, (String)ENTITY_TYPE_ADLS_GEN2_CONTAINER)) {
            containerName = resources[1];
            if (StringUtils.isEmpty((String)containerName)) {
                this.throwExceptionWithMessage("container-name not found in attribute 'qualifiedName': " + qualifiedName);
            }
            elements.put(RANGER_TYPE_ADLS_GEN2_ACCOUNT, new RangerPolicy.RangerPolicyResource(accountName));
            elements.put(RANGER_TYPE_ADLS_GEN2_CONTAINER, new RangerPolicy.RangerPolicyResource(containerName));
        } else if (StringUtils.equals((String)entityType, (String)ENTITY_TYPE_ADLS_GEN2_DIRECTORY)) {
            containerName = resources[1];
            String relativePath = resources[2];
            if (StringUtils.isEmpty((String)containerName)) {
                this.throwExceptionWithMessage("container-name not found in attribute 'qualifiedName': " + qualifiedName);
            }
            if (StringUtils.isEmpty((String)relativePath)) {
                this.throwExceptionWithMessage("relative-path not found in attribute 'qualifiedName': " + qualifiedName);
            }
            if (relativePath.endsWith(SEP_RELATIVE_PATH) && relativePath.length() != 1) {
                relativePath = relativePath.substring(0, relativePath.lastIndexOf(SEP_RELATIVE_PATH));
            }
            elements.put(RANGER_TYPE_ADLS_GEN2_ACCOUNT, new RangerPolicy.RangerPolicyResource(accountName));
            elements.put(RANGER_TYPE_ADLS_GEN2_CONTAINER, new RangerPolicy.RangerPolicyResource(containerName));
            elements.put(RANGER_TYPE_ADLS_GEN2_RELATIVE_PATH, new RangerPolicy.RangerPolicyResource(relativePath, Boolean.FALSE, Boolean.TRUE));
        } else {
            this.throwExceptionWithMessage("unrecognized entity-type: " + entityType);
        }
        RangerServiceResource ret = new RangerServiceResource(entityGuid, serviceName, elements);
        return ret;
    }

    private String[] parseQualifiedName(String qualifiedName) {
        int idxClusterNameSep;
        String[] ret = new String[4];
        if (StringUtils.isNotBlank((String)qualifiedName) && (idxClusterNameSep = qualifiedName.lastIndexOf(SEP_CONTAINER)) != -1) {
            int idxResourceStart;
            int idxContainerAccountSep;
            ret[3] = qualifiedName.substring(idxClusterNameSep + SEP_CONTAINER.length());
            int idxProtocolSep = qualifiedName.indexOf(SEP_PROTOCOL);
            if (idxProtocolSep != -1 && (idxContainerAccountSep = qualifiedName.indexOf(SEP_CONTAINER, idxResourceStart = idxProtocolSep + SEP_PROTOCOL.length())) != -1) {
                if (idxContainerAccountSep == idxClusterNameSep) {
                    ret[0] = qualifiedName.substring(idxResourceStart, idxClusterNameSep);
                } else {
                    ret[1] = qualifiedName.substring(idxResourceStart, idxContainerAccountSep);
                    int idxRelativePath = qualifiedName.indexOf(SEP_RELATIVE_PATH, idxContainerAccountSep + SEP_CONTAINER.length());
                    if (idxRelativePath == -1) {
                        ret[0] = qualifiedName.substring(idxContainerAccountSep + SEP_CONTAINER.length(), idxClusterNameSep);
                    } else {
                        ret[0] = qualifiedName.substring(idxContainerAccountSep + SEP_CONTAINER.length(), idxRelativePath);
                        ret[2] = qualifiedName.substring(idxRelativePath, idxClusterNameSep);
                    }
                }
            }
        }
        return ret;
    }
}

