/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.types;

import java.nio.ByteBuffer;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonByteBufferAllocator;

public final class Binary {
    private final ProtonBuffer buffer;
    private int hashCode;

    public Binary() {
        this((ProtonBuffer)null);
    }

    public Binary(ProtonBuffer buffer) {
        this.buffer = buffer;
    }

    public Binary(byte[] data) {
        this(data, 0, data.length);
    }

    public Binary(byte[] data, int offset, int length) {
        this.buffer = ProtonByteBufferAllocator.DEFAULT.wrap(data, offset, length);
    }

    public Binary copy() {
        if (this.buffer == null) {
            return new Binary();
        }
        return new Binary(this.buffer.copy());
    }

    public byte[] arrayCopy() {
        byte[] dataCopy = null;
        if (this.buffer != null) {
            dataCopy = new byte[this.buffer.getReadableBytes()];
            this.buffer.getBytes(this.buffer.getReadIndex(), dataCopy);
        }
        return dataCopy;
    }

    public ByteBuffer asByteBuffer() {
        return this.buffer != null ? this.buffer.toByteBuffer() : null;
    }

    public ProtonBuffer asProtonBuffer() {
        return this.buffer;
    }

    public final int hashCode() {
        int hc = this.hashCode;
        if (hc == 0 && this.buffer != null) {
            this.hashCode = this.buffer.hashCode();
        }
        return hc;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Binary other = (Binary)o;
        if (this.getLength() != other.getLength()) {
            return false;
        }
        if (this.buffer == null) {
            return other.buffer == null;
        }
        return this.buffer.equals(other.buffer);
    }

    public boolean hasArray() {
        return this.buffer != null ? this.buffer.hasArray() : false;
    }

    public int getArrayOffset() {
        return this.buffer != null ? this.buffer.getArrayOffset() : 0;
    }

    public byte[] getArray() {
        return this.buffer != null ? this.buffer.getArray() : null;
    }

    public int getLength() {
        return this.buffer != null ? this.buffer.getReadableBytes() : 0;
    }

    public String toString() {
        if (this.buffer == null) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.getLength(); ++i) {
            byte c = this.buffer.getByte(i);
            if (c > 31 && c < 127 && c != 92) {
                str.append((char)c);
                continue;
            }
            str.append(String.format("\\x%02x", c));
        }
        return str.toString();
    }
}

