/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.engine.impl;

import java.util.UUID;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonByteBufferAllocator;
import org.apache.qpid.protonj2.buffer.ProtonByteUtils;
import org.apache.qpid.protonj2.engine.impl.ProtonDeliveryTagGenerator;
import org.apache.qpid.protonj2.types.DeliveryTag;

public class ProtonUuidTagGenerator
extends ProtonDeliveryTagGenerator {
    @Override
    public DeliveryTag nextTag() {
        return new ProtonUuidDeliveryTag(UUID.randomUUID());
    }

    private static final class ProtonUuidDeliveryTag
    implements DeliveryTag {
        private static final int BYTES = 16;
        private final UUID tagValue;

        public ProtonUuidDeliveryTag(UUID tagValue) {
            this.tagValue = tagValue;
        }

        @Override
        public int tagLength() {
            return 16;
        }

        @Override
        public byte[] tagBytes() {
            byte[] tagView = new byte[16];
            ProtonByteUtils.writeLong(this.tagValue.getMostSignificantBits(), tagView, 0);
            ProtonByteUtils.writeLong(this.tagValue.getLeastSignificantBits(), tagView, 8);
            return tagView;
        }

        @Override
        public ProtonBuffer tagBuffer() {
            return ProtonByteBufferAllocator.DEFAULT.wrap(this.tagBytes());
        }

        @Override
        public DeliveryTag copy() {
            return new ProtonUuidDeliveryTag(this.tagValue);
        }

        @Override
        public void writeTo(ProtonBuffer buffer) {
            buffer.writeLong(this.tagValue.getMostSignificantBits());
            buffer.writeLong(this.tagValue.getLeastSignificantBits());
        }

        public int hashCode() {
            return this.tagValue.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.tagValue.equals(((ProtonUuidDeliveryTag)obj).tagValue);
        }

        public String toString() {
            return this.tagValue.toString();
        }
    }
}

