/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.engine.impl;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonCompositeBuffer;
import org.apache.qpid.protonj2.engine.EventHandler;
import org.apache.qpid.protonj2.engine.IncomingDelivery;
import org.apache.qpid.protonj2.engine.impl.ProtonAttachments;
import org.apache.qpid.protonj2.engine.impl.ProtonReceiver;
import org.apache.qpid.protonj2.types.DeliveryTag;
import org.apache.qpid.protonj2.types.transport.DeliveryState;

public class ProtonIncomingDelivery
implements IncomingDelivery {
    private final DeliveryTag deliveryTag;
    private final ProtonReceiver link;
    private final long deliveryId;
    private boolean complete;
    private int messageFormat;
    private boolean aborted;
    private int transferCount;
    private int claimedBytes;
    private DeliveryState defaultDeliveryState;
    private DeliveryState localState;
    private boolean locallySettled;
    private DeliveryState remoteState;
    private boolean remotelySettled;
    private ProtonBuffer payload;
    private ProtonCompositeBuffer aggregate;
    private ProtonAttachments attachments;
    private Object linkedResource;
    private EventHandler<IncomingDelivery> deliveryReadEventHandler = null;
    private EventHandler<IncomingDelivery> deliveryAbortedEventHandler = null;
    private EventHandler<IncomingDelivery> deliveryUpdatedEventHandler = null;

    public ProtonIncomingDelivery(ProtonReceiver link, long deliveryId, DeliveryTag deliveryTag) {
        this.deliveryId = deliveryId;
        this.deliveryTag = deliveryTag;
        this.link = link;
    }

    @Override
    public ProtonReceiver getLink() {
        return this.link;
    }

    @Override
    public ProtonAttachments getAttachments() {
        return this.attachments == null ? (this.attachments = new ProtonAttachments()) : this.attachments;
    }

    @Override
    public ProtonIncomingDelivery setLinkedResource(Object resource) {
        this.linkedResource = resource;
        return this;
    }

    @Override
    public <T> T getLinkedResource() {
        return (T)this.linkedResource;
    }

    @Override
    public <T> T getLinkedResource(Class<T> typeClass) {
        return typeClass.cast(this.linkedResource);
    }

    @Override
    public DeliveryTag getTag() {
        return this.deliveryTag;
    }

    @Override
    public DeliveryState getState() {
        return this.localState;
    }

    @Override
    public DeliveryState getRemoteState() {
        return this.remoteState;
    }

    @Override
    public int getMessageFormat() {
        return this.messageFormat;
    }

    ProtonIncomingDelivery setMessageFormat(int messageFormat) {
        this.messageFormat = messageFormat;
        return this;
    }

    @Override
    public boolean isPartial() {
        return !this.complete || this.aborted;
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    @Override
    public boolean isSettled() {
        return this.locallySettled;
    }

    @Override
    public boolean isRemotelySettled() {
        return this.remotelySettled;
    }

    @Override
    public ProtonIncomingDelivery setDefaultDeliveryState(DeliveryState state) {
        this.defaultDeliveryState = state;
        return this;
    }

    @Override
    public DeliveryState getDefaultDeliveryState() {
        return this.defaultDeliveryState;
    }

    @Override
    public IncomingDelivery disposition(DeliveryState state) {
        return this.disposition(state, false);
    }

    @Override
    public IncomingDelivery disposition(DeliveryState state, boolean settle) {
        if (this.locallySettled) {
            if (this.localState != null && !this.localState.equals(state) || this.localState != state) {
                throw new IllegalStateException("Cannot update disposition on an already settled Delivery");
            }
            return this;
        }
        this.locallySettled = settle;
        this.localState = state;
        this.link.disposition(this);
        return this;
    }

    @Override
    public IncomingDelivery settle() {
        return this.disposition(this.localState, true);
    }

    @Override
    public int available() {
        return this.payload == null ? 0 : this.payload.getReadableBytes();
    }

    @Override
    public ProtonBuffer readAll() {
        ProtonBuffer result = null;
        if (this.payload != null) {
            int bytesRead = this.claimedBytes -= this.payload.getReadableBytes();
            result = this.payload;
            this.payload = null;
            this.aggregate = null;
            if (bytesRead < 0) {
                this.claimedBytes = 0;
                this.link.deliveryRead(this, -bytesRead);
            }
        }
        return result;
    }

    @Override
    public ProtonIncomingDelivery readBytes(ProtonBuffer buffer) {
        if (this.payload != null) {
            int bytesRead = this.payload.getReadableBytes();
            this.payload.readBytes(buffer);
            bytesRead -= this.payload.getReadableBytes();
            if (!this.payload.isReadable()) {
                this.payload = null;
                this.aggregate = null;
            }
            if ((bytesRead = (this.claimedBytes -= bytesRead)) < 0) {
                this.claimedBytes = 0;
                this.link.deliveryRead(this, -bytesRead);
            }
        }
        return this;
    }

    @Override
    public ProtonIncomingDelivery readBytes(byte[] array, int offset, int length) {
        if (this.payload != null) {
            int bytesRead = this.payload.getReadableBytes();
            this.payload.readBytes(array, offset, length);
            bytesRead -= this.payload.getReadableBytes();
            if (!this.payload.isReadable()) {
                this.payload = null;
                this.aggregate = null;
            }
            if ((bytesRead = (this.claimedBytes -= bytesRead)) < 0) {
                this.claimedBytes = 0;
                this.link.deliveryRead(this, -bytesRead);
            }
        }
        return this;
    }

    @Override
    public IncomingDelivery claimAvailableBytes() {
        long unclaimed;
        long available = this.available();
        if (available > 0L && (unclaimed = available - (long)this.claimedBytes) > 0L) {
            this.claimedBytes = (int)((long)this.claimedBytes + unclaimed);
            this.link.deliveryRead(this, (int)unclaimed);
        }
        return this;
    }

    @Override
    public ProtonIncomingDelivery deliveryReadHandler(EventHandler<IncomingDelivery> handler) {
        this.deliveryReadEventHandler = handler;
        return this;
    }

    EventHandler<IncomingDelivery> deliveryReadHandler() {
        return this.deliveryReadEventHandler;
    }

    @Override
    public ProtonIncomingDelivery deliveryAbortedHandler(EventHandler<IncomingDelivery> handler) {
        this.deliveryAbortedEventHandler = handler;
        return this;
    }

    EventHandler<IncomingDelivery> deliveryAbortedHandler() {
        return this.deliveryAbortedEventHandler;
    }

    @Override
    public ProtonIncomingDelivery deliveryStateUpdatedHandler(EventHandler<IncomingDelivery> handler) {
        this.deliveryUpdatedEventHandler = handler;
        return this;
    }

    EventHandler<IncomingDelivery> deliveryStateUpdatedHandler() {
        return this.deliveryUpdatedEventHandler;
    }

    @Override
    public int getTransferCount() {
        return this.transferCount;
    }

    boolean isFirstTransfer() {
        return this.transferCount <= 1;
    }

    long getDeliveryId() {
        return this.deliveryId;
    }

    ProtonIncomingDelivery aborted() {
        this.aborted = true;
        if (this.payload != null) {
            int bytesRead = this.payload.getReadableBytes();
            this.payload = null;
            this.aggregate = null;
            this.link.deliveryRead(this, bytesRead);
        }
        return this;
    }

    ProtonIncomingDelivery completed() {
        this.complete = true;
        return this;
    }

    ProtonIncomingDelivery remotelySettled() {
        this.remotelySettled = true;
        return this;
    }

    ProtonIncomingDelivery remoteState(DeliveryState remoteState) {
        this.remoteState = remoteState;
        return this;
    }

    ProtonIncomingDelivery locallySettled() {
        this.locallySettled = true;
        return this;
    }

    ProtonIncomingDelivery localState(DeliveryState localState) {
        this.localState = localState;
        return this;
    }

    ProtonIncomingDelivery appendTransferPayload(ProtonBuffer buffer) {
        ++this.transferCount;
        if (this.payload == null) {
            this.payload = buffer;
        } else if (this.aggregate != null) {
            this.aggregate.append(buffer);
        } else {
            ProtonBuffer previous = this.payload;
            this.aggregate = new ProtonCompositeBuffer();
            this.payload = this.aggregate;
            this.aggregate.append(previous);
            this.aggregate.append(buffer);
        }
        return this;
    }

    public String toString() {
        return "ProtonIncomingDelivery { deliveryId = " + this.deliveryId + ", deliveryTag = " + this.deliveryTag + " };";
    }
}

