/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.client.AdvancedMessage;
import org.apache.qpid.protonj2.client.Message;
import org.apache.qpid.protonj2.client.StreamSender;
import org.apache.qpid.protonj2.client.StreamSenderOptions;
import org.apache.qpid.protonj2.client.StreamTracker;
import org.apache.qpid.protonj2.client.exceptions.ClientConnectionRemotelyClosedException;
import org.apache.qpid.protonj2.client.exceptions.ClientException;
import org.apache.qpid.protonj2.client.exceptions.ClientIllegalStateException;
import org.apache.qpid.protonj2.client.exceptions.ClientResourceRemotelyClosedException;
import org.apache.qpid.protonj2.client.exceptions.ClientSendTimedOutException;
import org.apache.qpid.protonj2.client.futures.ClientFuture;
import org.apache.qpid.protonj2.client.futures.ClientSynchronization;
import org.apache.qpid.protonj2.client.impl.ClientExceptionSupport;
import org.apache.qpid.protonj2.client.impl.ClientMessageSupport;
import org.apache.qpid.protonj2.client.impl.ClientNoOpStreamTracker;
import org.apache.qpid.protonj2.client.impl.ClientSenderBuilder;
import org.apache.qpid.protonj2.client.impl.ClientSenderLinkType;
import org.apache.qpid.protonj2.client.impl.ClientSession;
import org.apache.qpid.protonj2.client.impl.ClientStreamSenderMessage;
import org.apache.qpid.protonj2.client.impl.ClientStreamSession;
import org.apache.qpid.protonj2.client.impl.ClientStreamTracker;
import org.apache.qpid.protonj2.client.impl.ClientTracker;
import org.apache.qpid.protonj2.client.impl.ClientTransactionContext;
import org.apache.qpid.protonj2.engine.OutgoingDelivery;
import org.apache.qpid.protonj2.engine.Sender;
import org.apache.qpid.protonj2.engine.util.StringUtils;
import org.apache.qpid.protonj2.types.messaging.DeliveryAnnotations;
import org.apache.qpid.protonj2.types.transport.DeliveryState;
import org.apache.qpid.protonj2.types.transport.SenderSettleMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientStreamSender
extends ClientSenderLinkType<StreamSender>
implements StreamSender {
    private static final Logger LOG = LoggerFactory.getLogger(ClientStreamSender.class);
    private final StreamSenderOptions options;
    private final Deque<ClientOutgoingEnvelope> blocked = new ArrayDeque<ClientOutgoingEnvelope>();

    ClientStreamSender(ClientSession session, StreamSenderOptions options, String senderId, Sender protonSender) {
        super(session, senderId, options, protonSender);
        this.options = new StreamSenderOptions(options);
    }

    @Override
    public StreamTracker send(Message<?> message) throws ClientException {
        this.checkClosedOrFailed();
        return this.sendMessage(ClientMessageSupport.convertMessage(message), null, true);
    }

    @Override
    public StreamTracker send(Message<?> message, Map<String, Object> deliveryAnnotations) throws ClientException {
        this.checkClosedOrFailed();
        return this.sendMessage(ClientMessageSupport.convertMessage(message), null, true);
    }

    @Override
    public StreamTracker trySend(Message<?> message) throws ClientException {
        this.checkClosedOrFailed();
        return this.sendMessage(ClientMessageSupport.convertMessage(message), null, false);
    }

    @Override
    public StreamTracker trySend(Message<?> message, Map<String, Object> deliveryAnnotations) throws ClientException {
        this.checkClosedOrFailed();
        return this.sendMessage(ClientMessageSupport.convertMessage(message), null, false);
    }

    @Override
    public ClientStreamSenderMessage beginMessage() throws ClientException {
        return this.beginMessage((Map)null);
    }

    @Override
    public ClientStreamSenderMessage beginMessage(Map<String, Object> deliveryAnnotations) throws ClientException {
        this.checkClosedOrFailed();
        ClientFuture request = this.session.getFutureFactory().createFuture();
        DeliveryAnnotations annotations = deliveryAnnotations != null ? new DeliveryAnnotations(StringUtils.toSymbolKeyedMap(deliveryAnnotations)) : null;
        this.executor.execute(() -> {
            if (this.protonSender.current() != null) {
                request.failed(new ClientIllegalStateException("Cannot initiate a new streaming send until the previous one is complete"));
            } else {
                OutgoingDelivery streamDelivery = this.protonSender.next();
                ClientStreamTracker streamTracker = this.createTracker(streamDelivery);
                streamDelivery.setLinkedResource((Object)streamTracker);
                request.complete(new ClientStreamSenderMessage(this, streamTracker, annotations));
            }
        });
        return (ClientStreamSenderMessage)this.session.request(this, request);
    }

    StreamSenderOptions options() {
        return this.options;
    }

    @Override
    protected StreamSender self() {
        return this;
    }

    private void addToTailOfBlockedQueue(ClientOutgoingEnvelope send) {
        if (this.options.sendTimeout() > 0L && send.sendTimeout() == null) {
            send.sendTimeout(this.executor.schedule(() -> send.failed(send.createSendTimedOutException()), this.options.sendTimeout(), TimeUnit.MILLISECONDS));
        }
        this.blocked.addLast(send);
    }

    private void addToHeadOfBlockedQueue(ClientOutgoingEnvelope send) {
        if (this.options.sendTimeout() > 0L && send.sendTimeout() == null) {
            send.sendTimeout(this.executor.schedule(() -> send.failed(send.createSendTimedOutException()), this.options.sendTimeout(), TimeUnit.MILLISECONDS));
        }
        this.blocked.addFirst(send);
    }

    private StreamTracker sendMessage(AdvancedMessage<?> message, Map<String, Object> deliveryAnnotations, boolean waitForCredit) throws ClientException {
        ClientFuture operation = this.session.getFutureFactory().createFuture();
        ProtonBuffer buffer = message.encode(deliveryAnnotations);
        this.executor.execute(() -> {
            if (this.notClosedOrFailed(operation)) {
                try {
                    ClientOutgoingEnvelope envelope = new ClientOutgoingEnvelope(this, null, message.messageFormat(), buffer, true, operation);
                    if (this.protonSender.isSendable() && this.protonSender.current() == null) {
                        this.session.getTransactionContext().send(envelope, null, this.protonSender.getSenderSettleMode() == SenderSettleMode.SETTLED);
                    } else if (waitForCredit) {
                        this.addToTailOfBlockedQueue(envelope);
                    } else {
                        operation.complete(null);
                    }
                }
                catch (Exception error) {
                    operation.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
                }
            }
        });
        return (StreamTracker)this.session.request(this, operation);
    }

    StreamTracker sendMessage(ClientStreamSenderMessage context, ProtonBuffer payload, int messageFormat) throws ClientException {
        this.checkClosedOrFailed();
        ClientFuture<StreamTracker> operation = this.session.getFutureFactory().createFuture();
        ProtonBuffer buffer = payload;
        ClientOutgoingEnvelope envelope = new ClientOutgoingEnvelope(this, context.getProtonDelivery(), messageFormat, buffer, context.completed(), operation);
        this.executor.execute(() -> {
            if (this.notClosedOrFailed(operation, context.getProtonDelivery().getLink())) {
                try {
                    if (this.protonSender.isSendable()) {
                        this.session.getTransactionContext().send(envelope, null, this.isSendingSettled());
                    } else {
                        this.addToHeadOfBlockedQueue(envelope);
                    }
                }
                catch (Exception error) {
                    operation.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
                }
            }
        });
        return this.session.request(this, operation);
    }

    private ClientStreamTracker createTracker(OutgoingDelivery delivery) {
        return new ClientStreamTracker(this, delivery);
    }

    private ClientNoOpStreamTracker createNoOpTracker() {
        return new ClientNoOpStreamTracker(this);
    }

    @Override
    void disposition(OutgoingDelivery delivery, DeliveryState state, boolean settled) throws ClientException {
        this.checkClosedOrFailed();
        this.executor.execute(() -> delivery.disposition(state, settled));
    }

    void abort(OutgoingDelivery delivery, ClientStreamTracker tracker) throws ClientException {
        this.checkClosedOrFailed();
        ClientFuture<StreamTracker> request = this.session().getFutureFactory().createFuture(new ClientSynchronization<StreamTracker>(){

            @Override
            public void onPendingSuccess(StreamTracker result) {
                ClientStreamSender.this.handleCreditStateUpdated(ClientStreamSender.this.protonLink());
            }

            @Override
            public void onPendingFailure(Throwable cause) {
                ClientStreamSender.this.handleCreditStateUpdated(ClientStreamSender.this.protonLink());
            }
        });
        this.executor.execute(() -> {
            if (delivery.getTransferCount() == 0) {
                delivery.abort();
                request.complete(tracker);
            } else {
                ClientOutgoingEnvelope envelope = new ClientOutgoingEnvelope(this, delivery, delivery.getMessageFormat(), null, false, request).abort();
                try {
                    if (this.protonSender.isSendable() && (this.protonSender.current() == null || this.protonSender.current() == delivery)) {
                        envelope.send(delivery.getState(), delivery.isSettled());
                    } else if (this.protonSender.current() == delivery) {
                        this.addToHeadOfBlockedQueue(envelope);
                    } else {
                        this.addToTailOfBlockedQueue(envelope);
                    }
                }
                catch (Exception error) {
                    request.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
                }
            }
        });
        this.session.request(this, request);
    }

    void complete(OutgoingDelivery delivery, ClientStreamTracker tracker) throws ClientException {
        this.checkClosedOrFailed();
        ClientFuture<StreamTracker> request = this.session().getFutureFactory().createFuture(new ClientSynchronization<StreamTracker>(){

            @Override
            public void onPendingSuccess(StreamTracker result) {
                ClientStreamSender.this.handleCreditStateUpdated(ClientStreamSender.this.protonLink());
            }

            @Override
            public void onPendingFailure(Throwable cause) {
                ClientStreamSender.this.handleCreditStateUpdated(ClientStreamSender.this.protonLink());
            }
        });
        this.executor.execute(() -> {
            ClientOutgoingEnvelope envelope = new ClientOutgoingEnvelope(this, delivery, delivery.getMessageFormat(), null, true, request);
            try {
                if (this.protonSender.isSendable() && (this.protonSender.current() == null || this.protonSender.current() == delivery)) {
                    envelope.send(delivery.getState(), delivery.isSettled());
                } else if (this.protonSender.current() == delivery) {
                    this.addToHeadOfBlockedQueue(envelope);
                } else {
                    this.addToTailOfBlockedQueue(envelope);
                }
            }
            catch (Exception error) {
                request.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
            }
        });
        this.session.request(this, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCreditStateUpdated(Sender sender) {
        if (!this.blocked.isEmpty()) {
            ClientOutgoingEnvelope held;
            while (sender.isSendable() && !this.blocked.isEmpty() && (held = this.blocked.peek()).delivery() == this.protonSender.current()) {
                LOG.trace("Dispatching previously held send");
                try {
                    this.session.getTransactionContext().send(held, null, this.isSendingSettled());
                }
                catch (Exception error) {
                    held.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
                }
                finally {
                    this.blocked.poll();
                }
            }
        }
        if (sender.isDraining() && sender.current() == null && this.blocked.isEmpty()) {
            sender.drained();
        }
    }

    @Override
    protected void linkSpecificLocalOpenHandler() {
        this.protonSender.creditStateUpdateHandler(this::handleCreditStateUpdated);
    }

    @Override
    protected void recreateLinkForReconnect() {
        this.protonSender.localCloseHandler(null);
        this.protonSender.localDetachHandler(null);
        this.protonSender.close();
        if (this.protonSender.hasUnsettled()) {
            this.failPendingUnsettledAndBlockedSends(new ClientConnectionRemotelyClosedException("Connection failed and send result is unknown"));
        }
        this.protonSender = ClientSenderBuilder.recreateSender(this.session, this.protonSender, this.options);
        this.protonSender.setLinkedResource((Object)this);
    }

    @Override
    protected void linkSpecificCleanupHandler(ClientException failureCause) {
        if (this.session instanceof ClientStreamSession) {
            this.session.closeAsync();
        }
        if (failureCause != null) {
            this.failPendingUnsettledAndBlockedSends(failureCause);
        } else {
            this.failPendingUnsettledAndBlockedSends(new ClientResourceRemotelyClosedException("The sender link has closed"));
        }
    }

    private void failPendingUnsettledAndBlockedSends(ClientException cause) {
        this.protonSender.unsettled().forEach(delivery -> {
            try {
                ClientTracker tracker = (ClientTracker)delivery.getLinkedResource();
                ((ClientFuture)tracker.settlementFuture()).failed(cause);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.blocked.removeIf(held -> {
            held.failed(cause);
            return true;
        });
    }

    @Override
    protected void linkSpecificLocalCloseHandler() {
    }

    @Override
    protected void linkSpecificRemoteOpenHandler() {
    }

    @Override
    protected void linkSpecificRemoteCloseHandler() {
    }

    public static final class ClientOutgoingEnvelope
    implements ClientTransactionContext.Sendable {
        private final ProtonBuffer payload;
        private final ClientFuture<StreamTracker> request;
        private final ClientStreamSender sender;
        private final boolean complete;
        private final int messageFormat;
        private boolean aborted;
        private ScheduledFuture<?> sendTimeout;
        private OutgoingDelivery delivery;

        public ClientOutgoingEnvelope(ClientStreamSender sender, OutgoingDelivery delivery, int messageFormat, ProtonBuffer payload, boolean complete, ClientFuture<StreamTracker> request) {
            this.payload = payload;
            this.request = request;
            this.sender = sender;
            this.complete = complete;
            this.messageFormat = messageFormat;
            this.delivery = delivery;
        }

        public ScheduledFuture<?> sendTimeout() {
            return this.sendTimeout;
        }

        public void sendTimeout(ScheduledFuture<?> sendTimeout) {
            this.sendTimeout = sendTimeout;
        }

        public ProtonBuffer payload() {
            return this.payload;
        }

        public OutgoingDelivery delivery() {
            return this.delivery;
        }

        public ClientOutgoingEnvelope abort() {
            this.aborted = true;
            return this;
        }

        public boolean aborted() {
            return this.aborted;
        }

        @Override
        public void discard() {
            if (this.sendTimeout != null) {
                this.sendTimeout.cancel(true);
                this.sendTimeout = null;
            }
            if (this.delivery != null) {
                ClientTracker tracker = (ClientTracker)this.delivery.getLinkedResource();
                if (tracker != null) {
                    ((ClientFuture)tracker.settlementFuture()).complete(tracker);
                }
                this.request.complete((StreamTracker)this.delivery.getLinkedResource());
            } else {
                this.request.complete(this.sender.createNoOpTracker());
            }
        }

        public ClientOutgoingEnvelope succeeded() {
            if (this.sendTimeout != null) {
                this.sendTimeout.cancel(true);
            }
            this.request.complete((StreamTracker)this.delivery.getLinkedResource());
            return this;
        }

        public ClientOutgoingEnvelope failed(ClientException exception) {
            if (this.sendTimeout != null) {
                this.sendTimeout.cancel(true);
            }
            this.request.failed(exception);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(DeliveryState state, boolean settled) {
            if (this.delivery == null) {
                this.delivery = this.sender.protonLink().next();
                this.delivery.setLinkedResource((Object)this.sender.createTracker(this.delivery));
            }
            if (this.delivery.getTransferCount() == 0) {
                this.delivery.setMessageFormat(this.messageFormat);
                this.delivery.disposition(state, settled);
            }
            if (this.aborted()) {
                this.delivery.abort();
                this.succeeded();
            } else {
                boolean wasAutoFlushOn = this.sender.connection().autoFlushOff();
                try {
                    this.delivery.streamBytes(this.payload, this.complete);
                    if (this.payload != null && this.payload.isReadable()) {
                        this.sender.addToHeadOfBlockedQueue(this);
                    } else {
                        this.succeeded();
                    }
                }
                finally {
                    if (wasAutoFlushOn) {
                        this.sender.connection().flush();
                        this.sender.connection().autoFlushOn();
                    }
                }
            }
        }

        public ClientException createSendTimedOutException() {
            return new ClientSendTimedOutException("Timed out waiting for credit to send");
        }
    }
}

