/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.qpid.protonj2.client.LinkOptions;
import org.apache.qpid.protonj2.client.SenderOptions;
import org.apache.qpid.protonj2.client.SessionOptions;
import org.apache.qpid.protonj2.client.SourceOptions;
import org.apache.qpid.protonj2.client.StreamSenderOptions;
import org.apache.qpid.protonj2.client.TargetOptions;
import org.apache.qpid.protonj2.client.exceptions.ClientException;
import org.apache.qpid.protonj2.client.impl.ClientConversionSupport;
import org.apache.qpid.protonj2.client.impl.ClientDeliveryState;
import org.apache.qpid.protonj2.client.impl.ClientSender;
import org.apache.qpid.protonj2.client.impl.ClientSession;
import org.apache.qpid.protonj2.client.impl.ClientStreamSender;
import org.apache.qpid.protonj2.engine.Sender;
import org.apache.qpid.protonj2.engine.Session;
import org.apache.qpid.protonj2.engine.impl.ProtonDeliveryTagGenerator;
import org.apache.qpid.protonj2.types.UnsignedInteger;
import org.apache.qpid.protonj2.types.messaging.Outcome;
import org.apache.qpid.protonj2.types.messaging.Source;
import org.apache.qpid.protonj2.types.messaging.Target;
import org.apache.qpid.protonj2.types.messaging.TerminusDurability;
import org.apache.qpid.protonj2.types.messaging.TerminusExpiryPolicy;
import org.apache.qpid.protonj2.types.transactions.Coordinator;
import org.apache.qpid.protonj2.types.transport.ReceiverSettleMode;
import org.apache.qpid.protonj2.types.transport.SenderSettleMode;

final class ClientSenderBuilder {
    private final ClientSession session;
    private final SessionOptions sessionOptions;
    private final AtomicInteger senderCounter = new AtomicInteger();
    private volatile SenderOptions defaultSenderOptions;
    private volatile StreamSenderOptions defaultStreamSenderOptions;

    ClientSenderBuilder(ClientSession session) {
        this.session = session;
        this.sessionOptions = session.options();
    }

    public ClientSender sender(String address, SenderOptions senderOptions) throws ClientException {
        SenderOptions options = senderOptions != null ? senderOptions : this.getDefaultSenderOptions();
        String senderId = this.nextSenderId();
        Sender protonSender = ClientSenderBuilder.createSender(this.session.getProtonSession(), address, options, senderId);
        return new ClientSender(this.session, options, senderId, protonSender);
    }

    public ClientSender anonymousSender(SenderOptions senderOptions) throws ClientException {
        SenderOptions options = senderOptions != null ? senderOptions : this.getDefaultSenderOptions();
        String senderId = this.nextSenderId();
        Sender protonSender = ClientSenderBuilder.createSender(this.session.getProtonSession(), null, options, senderId);
        return new ClientSender(this.session, options, senderId, protonSender);
    }

    public ClientStreamSender streamSender(String address, StreamSenderOptions senderOptions) throws ClientException {
        StreamSenderOptions options = senderOptions != null ? senderOptions : this.getDefaultStreamSenderOptions();
        String senderId = this.nextSenderId();
        Sender protonSender = ClientSenderBuilder.createSender(this.session.getProtonSession(), address, options, senderId);
        return new ClientStreamSender(this.session, options, senderId, protonSender);
    }

    private static Sender createSender(Session protonSession, String address, LinkOptions<?> options, String senderId) {
        Object linkName = options.linkName() != null ? options.linkName() : "sender-" + senderId;
        Sender protonSender = protonSession.sender((String)linkName);
        switch (options.deliveryMode()) {
            case AT_MOST_ONCE: {
                protonSender.setSenderSettleMode(SenderSettleMode.SETTLED);
                protonSender.setReceiverSettleMode(ReceiverSettleMode.FIRST);
                break;
            }
            case AT_LEAST_ONCE: {
                protonSender.setSenderSettleMode(SenderSettleMode.UNSETTLED);
                protonSender.setReceiverSettleMode(ReceiverSettleMode.FIRST);
            }
        }
        protonSender.setOfferedCapabilities(ClientConversionSupport.toSymbolArray(options.offeredCapabilities()));
        protonSender.setDesiredCapabilities(ClientConversionSupport.toSymbolArray(options.desiredCapabilities()));
        protonSender.setProperties(ClientConversionSupport.toSymbolKeyedMap(options.properties()));
        protonSender.setTarget(ClientSenderBuilder.createTarget(address, options));
        protonSender.setSource(ClientSenderBuilder.createSource(senderId, options));
        if (protonSender.getSenderSettleMode() == SenderSettleMode.SETTLED) {
            protonSender.setDeliveryTagGenerator(ProtonDeliveryTagGenerator.BUILTIN.EMPTY.createGenerator());
        } else {
            protonSender.setDeliveryTagGenerator(ProtonDeliveryTagGenerator.BUILTIN.POOLED.createGenerator());
        }
        return protonSender;
    }

    private static Source createSource(String address, LinkOptions<?> options) {
        SourceOptions sourceOptions = options.sourceOptions();
        Source source = new Source();
        source.setAddress(address);
        source.setOutcomes(ClientConversionSupport.outcomesToSymbols(sourceOptions.outcomes()));
        source.setDefaultOutcome((Outcome)ClientDeliveryState.asProtonType(sourceOptions.defaultOutcome()));
        source.setCapabilities(ClientConversionSupport.toSymbolArray(sourceOptions.capabilities()));
        if (sourceOptions.timeout() >= 0L) {
            source.setTimeout(UnsignedInteger.valueOf((long)sourceOptions.timeout()));
        }
        if (sourceOptions.durabilityMode() != null) {
            source.setDurable(ClientConversionSupport.asProtonType(sourceOptions.durabilityMode()));
        } else {
            source.setDurable(TerminusDurability.NONE);
        }
        if (sourceOptions.expiryPolicy() != null) {
            source.setExpiryPolicy(ClientConversionSupport.asProtonType(sourceOptions.expiryPolicy()));
        } else {
            source.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
        }
        if (sourceOptions.distributionMode() != null) {
            source.setDistributionMode(ClientConversionSupport.asProtonType(sourceOptions.distributionMode()));
        }
        if (sourceOptions.timeout() >= 0L) {
            source.setTimeout(UnsignedInteger.valueOf((long)sourceOptions.timeout()));
        }
        if (sourceOptions.filters() != null) {
            source.setFilter(ClientConversionSupport.toSymbolKeyedMap(sourceOptions.filters()));
        }
        return source;
    }

    private static Target createTarget(String address, LinkOptions<?> options) {
        TargetOptions targetOptions = options.targetOptions();
        Target target = new Target();
        target.setAddress(address);
        target.setCapabilities(ClientConversionSupport.toSymbolArray(targetOptions.capabilities()));
        if (targetOptions.durabilityMode() != null) {
            target.setDurable(ClientConversionSupport.asProtonType(targetOptions.durabilityMode()));
        }
        if (targetOptions.expiryPolicy() != null) {
            target.setExpiryPolicy(ClientConversionSupport.asProtonType(targetOptions.expiryPolicy()));
        }
        if (targetOptions.timeout() >= 0L) {
            target.setTimeout(UnsignedInteger.valueOf((long)targetOptions.timeout()));
        }
        return target;
    }

    public static Sender recreateSender(ClientSession session, Sender previousSender, LinkOptions<?> options) {
        Sender protonSender = session.getProtonSession().sender(previousSender.getName());
        protonSender.setSource(previousSender.getSource());
        if (previousSender.getTarget() instanceof Coordinator) {
            protonSender.setTarget((Coordinator)previousSender.getTarget());
        } else {
            protonSender.setTarget((Target)previousSender.getTarget());
        }
        protonSender.setDeliveryTagGenerator(previousSender.getDeliveryTagGenerator());
        protonSender.setSenderSettleMode(previousSender.getSenderSettleMode());
        protonSender.setReceiverSettleMode(previousSender.getReceiverSettleMode());
        protonSender.setOfferedCapabilities(ClientConversionSupport.toSymbolArray(options.offeredCapabilities()));
        protonSender.setDesiredCapabilities(ClientConversionSupport.toSymbolArray(options.desiredCapabilities()));
        protonSender.setProperties(ClientConversionSupport.toSymbolKeyedMap(options.properties()));
        return protonSender;
    }

    private String nextSenderId() {
        return this.session.id() + ":" + this.senderCounter.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SenderOptions getDefaultSenderOptions() {
        SenderOptions senderOptions = this.defaultSenderOptions;
        if (senderOptions == null) {
            ClientSenderBuilder clientSenderBuilder = this;
            synchronized (clientSenderBuilder) {
                senderOptions = this.defaultSenderOptions;
                if (senderOptions == null) {
                    senderOptions = new SenderOptions();
                    senderOptions.openTimeout(this.sessionOptions.openTimeout());
                    senderOptions.closeTimeout(this.sessionOptions.closeTimeout());
                    senderOptions.requestTimeout(this.sessionOptions.requestTimeout());
                    senderOptions.sendTimeout(this.sessionOptions.sendTimeout());
                }
                this.defaultSenderOptions = senderOptions;
            }
        }
        return senderOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamSenderOptions getDefaultStreamSenderOptions() {
        StreamSenderOptions senderOptions = this.defaultStreamSenderOptions;
        if (senderOptions == null) {
            ClientSenderBuilder clientSenderBuilder = this;
            synchronized (clientSenderBuilder) {
                senderOptions = this.defaultStreamSenderOptions;
                if (senderOptions == null) {
                    senderOptions = new StreamSenderOptions();
                    senderOptions.openTimeout(this.sessionOptions.openTimeout());
                    senderOptions.closeTimeout(this.sessionOptions.closeTimeout());
                    senderOptions.requestTimeout(this.sessionOptions.requestTimeout());
                    senderOptions.sendTimeout(this.sessionOptions.sendTimeout());
                }
                this.defaultStreamSenderOptions = senderOptions;
            }
        }
        return senderOptions;
    }
}

