/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.engine.impl;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonByteBufferAllocator;
import org.apache.qpid.protonj2.buffer.ProtonByteUtils;
import org.apache.qpid.protonj2.engine.impl.ProtonDeliveryTagGenerator;
import org.apache.qpid.protonj2.types.DeliveryTag;

public class ProtonSequentialTagGenerator
extends ProtonDeliveryTagGenerator {
    protected long nextTagId = 0L;

    @Override
    public DeliveryTag nextTag() {
        return new ProtonNumericDeliveryTag(this.nextTagId++);
    }

    void setNextTagId(long nextIdValue) {
        this.nextTagId = nextIdValue;
    }

    protected static class ProtonNumericDeliveryTag
    implements DeliveryTag {
        protected final long tagValue;

        public ProtonNumericDeliveryTag(long tagValue) {
            this.tagValue = tagValue;
        }

        @Override
        public int tagLength() {
            if (this.tagValue < 0L) {
                return 8;
            }
            if (this.tagValue <= 255L) {
                return 1;
            }
            if (this.tagValue <= 65535L) {
                return 2;
            }
            if (this.tagValue <= 0xFFFFFFFFL) {
                return 4;
            }
            return 8;
        }

        @Override
        public byte[] tagBytes() {
            if (this.tagValue < 0L) {
                return ProtonByteUtils.toByteArray(this.tagValue);
            }
            if (this.tagValue <= 255L) {
                return ProtonByteUtils.toByteArray((byte)this.tagValue);
            }
            if (this.tagValue <= 65535L) {
                return ProtonByteUtils.toByteArray((short)this.tagValue);
            }
            if (this.tagValue <= 0xFFFFFFFFL) {
                return ProtonByteUtils.toByteArray((int)this.tagValue);
            }
            return ProtonByteUtils.toByteArray(this.tagValue);
        }

        @Override
        public ProtonBuffer tagBuffer() {
            return ProtonByteBufferAllocator.DEFAULT.wrap(this.tagBytes());
        }

        @Override
        public void release() {
        }

        @Override
        public DeliveryTag copy() {
            return new ProtonNumericDeliveryTag(this.tagValue);
        }

        public int hashCode() {
            return Long.hashCode(this.tagValue);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProtonNumericDeliveryTag other = (ProtonNumericDeliveryTag)obj;
            return this.tagValue == other.tagValue;
        }

        public String toString() {
            return "{" + this.tagValue + "}";
        }

        @Override
        public void writeTo(ProtonBuffer buffer) {
            if (this.tagValue < 0L) {
                buffer.writeLong(this.tagValue);
            } else if (this.tagValue <= 255L) {
                buffer.writeByte((int)this.tagValue);
            } else if (this.tagValue <= 65535L) {
                buffer.writeShort((short)this.tagValue);
            } else if (this.tagValue <= 0xFFFFFFFFL) {
                buffer.writeInt((int)this.tagValue);
            } else {
                buffer.writeLong(this.tagValue);
            }
        }
    }
}

