/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.primitives;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.encoders.AbstractPrimitiveTypeEncoder;
import org.apache.qpid.protonj2.types.Decimal128;

public final class Decimal128TypeEncoder
extends AbstractPrimitiveTypeEncoder<Decimal128> {
    @Override
    public Class<Decimal128> getTypeClass() {
        return Decimal128.class;
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, Decimal128 value) {
        buffer.writeByte(-108);
        buffer.writeLong(value.getMostSignificantBits());
        buffer.writeLong(value.getLeastSignificantBits());
    }

    @Override
    public void writeRawArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte(-108);
        for (Object value : values) {
            Decimal128 decimal128 = (Decimal128)value;
            buffer.writeLong(decimal128.getMostSignificantBits());
            buffer.writeLong(decimal128.getLeastSignificantBits());
        }
    }
}

