/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.transactions;

import java.io.InputStream;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.StreamTypeDecoder;
import org.apache.qpid.protonj2.codec.TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.AbstractDescribedTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.messaging.Outcome;
import org.apache.qpid.protonj2.types.transactions.TransactionalState;

public final class TransactionStateTypeDecoder
extends AbstractDescribedTypeDecoder<TransactionalState> {
    private static final int MIN_TRANSACTION_STATE_LIST_ENTRIES = 1;
    private static final int MAX_TRANSACTION_STATE_LIST_ENTRIES = 2;

    @Override
    public Class<TransactionalState> getTypeClass() {
        return TransactionalState.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return TransactionalState.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return TransactionalState.DESCRIPTOR_SYMBOL;
    }

    @Override
    public TransactionalState readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        return this.readTransactionalState(buffer, state, (ListTypeDecoder)TransactionStateTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public TransactionalState[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        TransactionalState[] result = new TransactionalState[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readTransactionalState(buffer, state, (ListTypeDecoder)TransactionStateTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        TransactionStateTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(buffer, state);
    }

    private TransactionalState readTransactionalState(ProtonBuffer buffer, DecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        TransactionalState transactionalState = new TransactionalState();
        int size = listDecoder.readSize(buffer);
        int count = listDecoder.readCount(buffer);
        if (count < 1) {
            throw new DecodeException("Not enough entries in TransactionalState list encoding: " + count);
        }
        if (count > 2) {
            throw new DecodeException("To many entries in TransactionalState list encoding: " + count);
        }
        block4: for (int index = 0; index < count; ++index) {
            switch (index) {
                case 0: {
                    transactionalState.setTxnId(state.getDecoder().readBinary(buffer, state));
                    continue block4;
                }
                case 1: {
                    transactionalState.setOutcome((Outcome)state.getDecoder().readObject(buffer, state));
                }
            }
        }
        return transactionalState;
    }

    @Override
    public TransactionalState readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        return this.readTransactionalState(stream, state, (ListTypeDecoder)TransactionStateTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public TransactionalState[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        TransactionalState[] result = new TransactionalState[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readTransactionalState(stream, state, (ListTypeDecoder)TransactionStateTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        TransactionStateTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(stream, state);
    }

    private TransactionalState readTransactionalState(InputStream stream, StreamDecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        TransactionalState transactionalState = new TransactionalState();
        int size = listDecoder.readSize(stream);
        int count = listDecoder.readCount(stream);
        if (count < 1) {
            throw new DecodeException("Not enough entries in TransactionalState list encoding: " + count);
        }
        if (count > 2) {
            throw new DecodeException("To many entries in TransactionalState list encoding: " + count);
        }
        block4: for (int index = 0; index < count; ++index) {
            switch (index) {
                case 0: {
                    transactionalState.setTxnId(state.getDecoder().readBinary(stream, state));
                    continue block4;
                }
                case 1: {
                    transactionalState.setOutcome((Outcome)state.getDecoder().readObject(stream, state));
                }
            }
        }
        return transactionalState;
    }
}

