/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.messaging;

import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.Decoder;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoder;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.StreamTypeDecoder;
import org.apache.qpid.protonj2.codec.TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.AbstractDescribedTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.MapTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.NullTypeDecoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.messaging.ApplicationProperties;

public final class ApplicationPropertiesTypeDecoder
extends AbstractDescribedTypeDecoder<ApplicationProperties> {
    @Override
    public Class<ApplicationProperties> getTypeClass() {
        return ApplicationProperties.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return ApplicationProperties.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return ApplicationProperties.DESCRIPTOR_SYMBOL;
    }

    @Override
    public ApplicationProperties readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        if (decoder instanceof NullTypeDecoder) {
            return new ApplicationProperties(null);
        }
        return new ApplicationProperties(this.readMap(buffer, state, (MapTypeDecoder)ApplicationPropertiesTypeDecoder.checkIsExpectedTypeAndCast(MapTypeDecoder.class, decoder)));
    }

    public ApplicationProperties[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        ApplicationProperties[] result = new ApplicationProperties[count];
        if (decoder instanceof NullTypeDecoder) {
            for (int i = 0; i < count; ++i) {
                result[i] = new ApplicationProperties(null);
            }
            return result;
        }
        for (int i = 0; i < count; ++i) {
            result[i] = new ApplicationProperties(this.readMap(buffer, state, (MapTypeDecoder)ApplicationPropertiesTypeDecoder.checkIsExpectedTypeAndCast(MapTypeDecoder.class, decoder)));
        }
        return result;
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        if (!(decoder instanceof NullTypeDecoder)) {
            ApplicationPropertiesTypeDecoder.checkIsExpectedType(MapTypeDecoder.class, decoder);
            decoder.skipValue(buffer, state);
        }
    }

    private Map<String, Object> readMap(ProtonBuffer buffer, DecoderState state, MapTypeDecoder mapDecoder) throws DecodeException {
        int size = mapDecoder.readSize(buffer);
        int count = mapDecoder.readCount(buffer);
        if (count > buffer.getReadableBytes()) {
            throw new DecodeException(String.format("Map encoded size %d is specified to be greater than the amount of data available (%d)", size, buffer.getReadableBytes()));
        }
        Decoder decoder = state.getDecoder();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(count);
        for (int i = 0; i < count / 2; ++i) {
            String key = decoder.readString(buffer, state);
            Object value = decoder.readObject(buffer, state);
            map.put(key, value);
        }
        return map;
    }

    @Override
    public ApplicationProperties readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        if (decoder instanceof NullTypeDecoder) {
            return new ApplicationProperties(null);
        }
        return new ApplicationProperties(this.readMap(stream, state, (MapTypeDecoder)ApplicationPropertiesTypeDecoder.checkIsExpectedTypeAndCast(MapTypeDecoder.class, decoder)));
    }

    public ApplicationProperties[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        ApplicationProperties[] result = new ApplicationProperties[count];
        if (decoder instanceof NullTypeDecoder) {
            for (int i = 0; i < count; ++i) {
                result[i] = new ApplicationProperties(null);
            }
            return result;
        }
        for (int i = 0; i < count; ++i) {
            result[i] = new ApplicationProperties(this.readMap(stream, state, (MapTypeDecoder)ApplicationPropertiesTypeDecoder.checkIsExpectedTypeAndCast(MapTypeDecoder.class, decoder)));
        }
        return result;
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        if (!(decoder instanceof NullTypeDecoder)) {
            ApplicationPropertiesTypeDecoder.checkIsExpectedType(MapTypeDecoder.class, decoder);
            decoder.skipValue(stream, state);
        }
    }

    private Map<String, Object> readMap(InputStream stream, StreamDecoderState state, MapTypeDecoder mapDecoder) throws DecodeException {
        int size = mapDecoder.readSize(stream);
        int count = mapDecoder.readCount(stream);
        StreamDecoder decoder = state.getDecoder();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(count);
        for (int i = 0; i < count / 2; ++i) {
            String key = decoder.readString(stream, state);
            Object value = decoder.readObject(stream, state);
            map.put(key, value);
        }
        return map;
    }
}

