/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.buffer;

import java.nio.ByteBuffer;
import org.apache.qpid.protonj2.buffer.ProtonAbstractBuffer;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;

public class ProtonSlicedBuffer
extends ProtonAbstractBuffer {
    private final ProtonAbstractBuffer buffer;
    private final int indexOffset;

    protected ProtonSlicedBuffer(ProtonAbstractBuffer buffer, int offset, int capacity) {
        super(capacity);
        ProtonSlicedBuffer.checkSliceOutOfBounds(offset, capacity, buffer);
        if (buffer instanceof ProtonSlicedBuffer) {
            this.buffer = ((ProtonSlicedBuffer)buffer).buffer;
            this.indexOffset = ((ProtonSlicedBuffer)buffer).indexOffset + offset;
        } else {
            this.buffer = buffer;
            this.indexOffset = offset;
        }
        this.setWriteIndex(capacity);
    }

    @Override
    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    @Override
    public byte[] getArray() {
        return this.buffer.getArray();
    }

    @Override
    public int getArrayOffset() {
        return this.offset(this.buffer.getArrayOffset());
    }

    @Override
    public int capacity() {
        return this.maxCapacity();
    }

    @Override
    public ProtonBuffer capacity(int newCapacity) {
        throw new UnsupportedOperationException("Cannot adjust capacity of a buffer slice.");
    }

    @Override
    public ProtonBuffer duplicate() {
        return this.buffer.duplicate().setIndex(this.offset(this.getReadIndex()), this.offset(this.getWriteIndex()));
    }

    @Override
    public ProtonBuffer slice(int index, int length) {
        this.checkIndex(index, length);
        return this.buffer.slice(this.offset(index), length);
    }

    @Override
    public ProtonBuffer copy(int index, int length) {
        this.checkIndex(index, length);
        return this.buffer.copy(this.offset(index), length);
    }

    @Override
    public ByteBuffer toByteBuffer(int index, int length) {
        return this.buffer.toByteBuffer(this.offset(index), length).slice();
    }

    @Override
    public boolean getBoolean(int index) {
        this.checkIndex(index, 1);
        return this.buffer.getBoolean(this.offset(index));
    }

    @Override
    public byte getByte(int index) {
        this.checkIndex(index, 1);
        return this.buffer.getByte(this.offset(index));
    }

    @Override
    public short getUnsignedByte(int index) {
        this.checkIndex(index, 1);
        return this.buffer.getUnsignedByte(this.offset(index));
    }

    @Override
    public char getChar(int index) {
        this.checkIndex(index, 2);
        return this.buffer.getChar(this.offset(index));
    }

    @Override
    public short getShort(int index) {
        this.checkIndex(index, 2);
        return this.buffer.getShort(this.offset(index));
    }

    @Override
    public int getUnsignedShort(int index) {
        this.checkIndex(index, 2);
        return this.buffer.getUnsignedShort(this.offset(index));
    }

    @Override
    public int getInt(int index) {
        this.checkIndex(index, 4);
        return this.buffer.getInt(this.offset(index));
    }

    @Override
    public long getUnsignedInt(int index) {
        this.checkIndex(index, 4);
        return this.buffer.getUnsignedInt(this.offset(index));
    }

    @Override
    public long getLong(int index) {
        this.checkIndex(index, 8);
        return this.buffer.getLong(this.offset(index));
    }

    @Override
    public float getFloat(int index) {
        this.checkIndex(index, 4);
        return this.buffer.getFloat(this.offset(index));
    }

    @Override
    public double getDouble(int index) {
        this.checkIndex(index, 8);
        return this.buffer.getDouble(this.offset(index));
    }

    @Override
    public ProtonBuffer getBytes(int index, ProtonBuffer dst) {
        this.checkIndex(index, dst.getWritableBytes());
        this.buffer.getBytes(this.offset(index), dst);
        return this;
    }

    @Override
    public ProtonBuffer getBytes(int index, ProtonBuffer dst, int length) {
        this.checkIndex(index, length);
        this.buffer.getBytes(this.offset(index), dst);
        return this;
    }

    @Override
    public ProtonBuffer getBytes(int index, ProtonBuffer dst, int dstIndex, int length) {
        this.checkIndex(index, length);
        this.buffer.getBytes(this.offset(index), dst, dstIndex, length);
        return this;
    }

    @Override
    public ProtonBuffer getBytes(int index, byte[] dst) {
        this.checkIndex(index, dst.length);
        this.buffer.getBytes(this.offset(index), dst);
        return this;
    }

    @Override
    public ProtonBuffer getBytes(int index, byte[] dst, int offset, int length) {
        this.checkIndex(index, length);
        this.buffer.getBytes(this.offset(index), dst, offset, length);
        return this;
    }

    @Override
    public ProtonBuffer getBytes(int index, ByteBuffer destination) {
        this.checkIndex(index, destination.remaining());
        this.buffer.getBytes(this.offset(index), destination);
        return this;
    }

    @Override
    public ProtonBuffer setByte(int index, int value) {
        this.checkIndex(index, 1);
        this.buffer.setByte(this.offset(index), value);
        return this;
    }

    @Override
    public ProtonBuffer setBoolean(int index, boolean value) {
        this.checkIndex(index, 1);
        this.buffer.setBoolean(this.offset(index), value);
        return this;
    }

    @Override
    public ProtonBuffer setChar(int index, int value) {
        this.checkIndex(index, 2);
        this.buffer.setChar(this.offset(index), value);
        return this;
    }

    @Override
    public ProtonBuffer setShort(int index, int value) {
        this.checkIndex(index, 2);
        this.buffer.setShort(this.offset(index), value);
        return this;
    }

    @Override
    public ProtonBuffer setInt(int index, int value) {
        this.checkIndex(index, 4);
        this.buffer.setInt(this.offset(index), value);
        return this;
    }

    @Override
    public ProtonBuffer setLong(int index, long value) {
        this.checkIndex(index, 8);
        this.buffer.setLong(this.offset(index), value);
        return this;
    }

    @Override
    public ProtonBuffer setFloat(int index, float value) {
        this.checkIndex(index, 4);
        this.buffer.setFloat(this.offset(index), value);
        return this;
    }

    @Override
    public ProtonBuffer setDouble(int index, double value) {
        this.checkIndex(index, 8);
        this.buffer.setDouble(this.offset(index), value);
        return this;
    }

    @Override
    public ProtonBuffer setBytes(int index, ProtonBuffer source) {
        this.checkIndex(index, source.getReadableBytes());
        this.buffer.setBytes(this.offset(index), source);
        return this;
    }

    @Override
    public ProtonBuffer setBytes(int index, ProtonBuffer source, int length) {
        this.checkIndex(index, length);
        this.buffer.setBytes(this.offset(index), source, length);
        return this;
    }

    @Override
    public ProtonBuffer setBytes(int index, ProtonBuffer source, int sourceIndex, int length) {
        this.checkIndex(index, length);
        this.buffer.setBytes(this.offset(index), source, sourceIndex, length);
        return this;
    }

    @Override
    public ProtonBuffer setBytes(int index, byte[] source) {
        this.checkIndex(index, source.length);
        this.buffer.setBytes(this.offset(index), source);
        return this;
    }

    @Override
    public ProtonBuffer setBytes(int index, byte[] src, int srcIndex, int length) {
        this.checkIndex(index, length);
        this.buffer.setBytes(this.offset(index), src, srcIndex, length);
        return this;
    }

    @Override
    public ProtonBuffer setBytes(int index, ByteBuffer source) {
        this.checkIndex(index, source.remaining());
        this.buffer.setBytes(this.offset(index), source);
        return this;
    }

    static void checkSliceOutOfBounds(int index, int length, ProtonAbstractBuffer buffer) {
        if (ProtonSlicedBuffer.isOutOfBounds(index, length, buffer.capacity())) {
            throw new IndexOutOfBoundsException(buffer + ".slice(" + index + ", " + length + ")");
        }
    }

    private int offset(int index) {
        return index + this.indexOffset;
    }
}

