/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.buffer;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;

public class ProtonBufferOutputStream
extends OutputStream
implements DataOutput {
    private final ProtonBuffer buffer;
    private final int startWriteIndex;
    private DataOutputStream cachedDataOut;
    private boolean closed;

    public ProtonBufferOutputStream(ProtonBuffer buffer) {
        this.buffer = buffer;
        this.startWriteIndex = buffer.getWriteIndex();
    }

    public int getBytesWritten() {
        return this.buffer.getWriteIndex() - this.startWriteIndex;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        this.checkClosed();
        this.buffer.writeBoolean(value);
    }

    @Override
    public void write(int value) throws IOException {
        this.checkClosed();
        this.buffer.writeByte(value);
    }

    @Override
    public void write(byte[] array, int offset, int length) throws IOException {
        this.checkClosed();
        if (length != 0) {
            this.buffer.writeBytes(array, offset, length);
        }
    }

    @Override
    public void write(byte[] array) throws IOException {
        this.checkClosed();
        this.buffer.writeBytes(array);
    }

    @Override
    public void writeByte(int value) throws IOException {
        this.checkClosed();
        this.buffer.writeByte(value);
    }

    @Override
    public void writeShort(int value) throws IOException {
        this.checkClosed();
        this.buffer.writeShort((short)value);
    }

    @Override
    public void writeChar(int value) throws IOException {
        this.checkClosed();
        this.buffer.writeShort((short)value);
    }

    @Override
    public void writeInt(int value) throws IOException {
        this.checkClosed();
        this.buffer.writeInt(value);
    }

    @Override
    public void writeLong(long value) throws IOException {
        this.checkClosed();
        this.buffer.writeLong(value);
    }

    @Override
    public void writeFloat(float value) throws IOException {
        this.checkClosed();
        this.buffer.writeFloat(value);
    }

    @Override
    public void writeDouble(double value) throws IOException {
        this.checkClosed();
        this.buffer.writeDouble(value);
    }

    @Override
    public void writeBytes(String value) throws IOException {
        this.checkClosed();
        this.buffer.writeBytes(value.getBytes(StandardCharsets.US_ASCII));
    }

    @Override
    public void writeChars(String value) throws IOException {
        this.checkClosed();
        for (int i = 0; i < value.length(); ++i) {
            this.buffer.writeShort((short)value.charAt(i));
        }
    }

    @Override
    public void writeUTF(String value) throws IOException {
        this.checkClosed();
        if (this.cachedDataOut == null) {
            this.cachedDataOut = new DataOutputStream(this);
        }
        this.cachedDataOut.writeUTF(value);
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("The ProtonBuffer OutputStream has been closed");
        }
    }
}

