/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.types.transport;

import java.io.Serializable;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.transport.ErrorCondition;
import org.apache.qpid.protonj2.types.transport.Performative;

public final class Detach
implements Performative {
    public static final UnsignedLong DESCRIPTOR_CODE = UnsignedLong.valueOf(22L);
    public static final Symbol DESCRIPTOR_SYMBOL = Symbol.valueOf("amqp:detach:list");
    private static final long UINT_MAX = 0xFFFFFFFFL;
    private static final int HANDLE = 1;
    private static final int CLOSED = 2;
    private static final int ERROR = 4;
    private int modified = 0;
    private long handle;
    private boolean closed;
    private ErrorCondition error;

    public boolean isEmpty() {
        return this.modified == 0;
    }

    public int getElementCount() {
        return 32 - Integer.numberOfLeadingZeros(this.modified);
    }

    public boolean hasHandle() {
        return (this.modified & 1) == 1;
    }

    public boolean hasClosed() {
        return (this.modified & 2) == 2;
    }

    public boolean hasError() {
        return (this.modified & 4) == 4;
    }

    public long getHandle() {
        return this.handle;
    }

    public Detach setHandle(long handle) {
        if (handle < 0L || handle > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("The Handle value given is out of range: " + handle);
        }
        this.modified |= 1;
        this.handle = handle;
        return this;
    }

    public boolean getClosed() {
        return this.closed;
    }

    public Detach setClosed(boolean closed) {
        this.modified |= 2;
        this.closed = closed;
        return this;
    }

    public ErrorCondition getError() {
        return this.error;
    }

    public Detach setError(ErrorCondition error) {
        this.modified = error != null ? (this.modified |= 4) : (this.modified &= 0xFFFFFFFB);
        this.error = error;
        return this;
    }

    @Override
    public Detach copy() {
        Detach copy = new Detach();
        copy.handle = this.handle;
        copy.closed = this.closed;
        copy.error = this.error == null ? null : this.error.copy();
        copy.modified = this.modified;
        return copy;
    }

    @Override
    public Performative.PerformativeType getPerformativeType() {
        return Performative.PerformativeType.DETACH;
    }

    @Override
    public <E> void invoke(Performative.PerformativeHandler<E> handler, ProtonBuffer payload, int channel, E context) {
        handler.handleDetach(this, payload, channel, context);
    }

    public String toString() {
        return "Detach{handle=" + (Serializable)(this.hasHandle() ? Long.valueOf(this.handle) : "null") + ", closed=" + (Serializable)(this.hasClosed() ? Boolean.valueOf(this.closed) : "null") + ", error=" + this.error + "}";
    }
}

