/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.engine.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.qpid.protonj2.engine.util.RingQueue;
import org.apache.qpid.protonj2.types.UnsignedInteger;

public class SplayMap<E>
implements NavigableMap<UnsignedInteger, E> {
    private static final UnsignedComparator COMPARATOR = new UnsignedComparator();
    protected final RingQueue<SplayedEntry<E>> entryPool = new RingQueue(64);
    protected SplayedEntry<E> root;
    protected int size;
    protected int modCount;
    protected Set<UnsignedInteger> keySet;
    protected Collection<E> values;
    protected Set<Map.Entry<UnsignedInteger, E>> entrySet;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public E get(int key) {
        if (this.root == null) {
            return null;
        }
        if (this.root.key == key) {
            return this.root.value;
        }
        this.root = this.splay(this.root, key);
        if (this.root.key == key) {
            return this.root.value;
        }
        return null;
    }

    @Override
    public E put(int key, E value) {
        E oldValue = null;
        if (this.root == null) {
            this.root = this.entryPool.poll(SplayMap::createEntry).initialize(key, value);
        } else {
            this.root = this.splay(this.root, key);
            if (this.root.key == key) {
                oldValue = this.root.value;
                this.root.value = value;
            } else {
                SplayedEntry<E> node = this.entryPool.poll(SplayMap::createEntry).initialize(key, value);
                if (SplayMap.compare(key, this.root.key) < 0) {
                    this.shiftRootRightOf(node);
                } else {
                    this.shiftRootLeftOf(node);
                }
            }
        }
        if (oldValue == null) {
            this.entryAdded(this.root);
            ++this.size;
        }
        ++this.modCount;
        return oldValue;
    }

    @Override
    public E putIfAbsent(UnsignedInteger key, E value) {
        return this.putIfAbsent(key.intValue(), value);
    }

    @Override
    public E putIfAbsent(int key, E value) {
        if (this.root == null) {
            this.root = this.entryPool.poll(SplayMap::createEntry).initialize(key, value);
        } else {
            this.root = this.splay(this.root, key);
            if (this.root.key == key) {
                return this.root.value;
            }
            SplayedEntry<E> node = this.entryPool.poll(SplayMap::createEntry).initialize(key, value);
            if (SplayMap.compare(key, this.root.key) < 0) {
                this.shiftRootRightOf(node);
            } else {
                this.shiftRootLeftOf(node);
            }
        }
        this.entryAdded(this.root);
        ++this.size;
        ++this.modCount;
        return null;
    }

    private void shiftRootRightOf(SplayedEntry<E> newRoot) {
        newRoot.right = this.root;
        newRoot.left = this.root.left;
        if (newRoot.left != null) {
            newRoot.left.parent = newRoot;
        }
        this.root.left = null;
        this.root.parent = newRoot;
        this.root = newRoot;
    }

    private void shiftRootLeftOf(SplayedEntry<E> newRoot) {
        newRoot.left = this.root;
        newRoot.right = this.root.right;
        if (newRoot.right != null) {
            newRoot.right.parent = newRoot;
        }
        this.root.right = null;
        this.root.parent = newRoot;
        this.root = newRoot;
    }

    public E remove(UnsignedInteger key) {
        return this.remove(key.intValue());
    }

    public E remove(int key) {
        if (this.root == null) {
            return null;
        }
        this.root = this.splay(this.root, key);
        if (this.root.key != key) {
            return null;
        }
        Object removed = this.root.value;
        this.delete(this.root);
        return removed;
    }

    public boolean containsKey(int key) {
        if (this.root == null) {
            return false;
        }
        this.root = this.splay(this.root, key);
        return this.root.key == key;
    }

    @Override
    public E put(UnsignedInteger key, E value) {
        return this.put(key.intValue(), value);
    }

    @Override
    public E get(Object key) {
        return this.get(((Number)Number.class.cast(key)).intValue());
    }

    @Override
    public E remove(Object key) {
        return this.remove(((Number)Number.class.cast(key)).intValue());
    }

    @Override
    public boolean containsKey(Object key) {
        Number numericKey = (Number)key;
        return this.containsKey(numericKey.intValue());
    }

    @Override
    public void clear() {
        this.root = null;
        this.size = 0;
    }

    @Override
    public void putAll(Map<? extends UnsignedInteger, ? extends E> source) {
        for (Map.Entry<UnsignedInteger, E> entry : source.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean containsValue(Object value) {
        SplayedEntry<E> entry = this.firstEntry(this.root);
        while (entry != null) {
            if (entry.valueEquals(value)) {
                return true;
            }
            entry = this.successor(entry);
        }
        return false;
    }

    @Override
    public Set<UnsignedInteger> keySet() {
        if (this.keySet == null) {
            this.keySet = new SplayMapKeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<E> values() {
        if (this.values == null) {
            this.values = new SplayMapValues();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<UnsignedInteger, E>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new SplayMapEntrySet();
        }
        return this.entrySet;
    }

    @Override
    public void forEach(BiConsumer<? super UnsignedInteger, ? super E> action) {
        Objects.requireNonNull(action);
        SplayedEntry<E> entry = this.firstEntry(this.root);
        while (entry != null) {
            action.accept(entry.getKey(), entry.getValue());
            entry = this.successor(entry);
        }
    }

    public void forEach(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        SplayedEntry<E> entry = this.firstEntry(this.root);
        while (entry != null) {
            action.accept(entry.getValue());
            entry = this.successor(entry);
        }
    }

    @Override
    public void replaceAll(BiFunction<? super UnsignedInteger, ? super E, ? extends E> function) {
        Objects.requireNonNull(function, "The replacement function parameter cannot be null");
        int initialModCount = this.modCount;
        SplayedEntry<E> entry = this.firstEntry(this.root);
        while (entry != null) {
            entry.value = function.apply(entry.getKey(), entry.value);
            entry = this.successor(entry);
        }
        if (this.modCount != initialModCount) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public boolean remove(Object key, Object value) {
        Number numericKey = (Number)key;
        return this.remove(numericKey.intValue(), value);
    }

    public boolean remove(int key, Object value) {
        this.root = this.splay(this.root, key);
        if (this.root == null || this.root.key != key || !Objects.equals(this.root.value, value)) {
            return false;
        }
        this.delete(this.root);
        return true;
    }

    @Override
    public boolean replace(UnsignedInteger key, E oldValue, E newValue) {
        return this.replace(key.intValue(), oldValue, newValue);
    }

    @Override
    public boolean replace(int key, E oldValue, E newValue) {
        this.root = this.splay(this.root, key);
        if (this.root == null || this.root.key != key || !Objects.equals(this.root.value, oldValue)) {
            return false;
        }
        this.root.setValue(newValue);
        return true;
    }

    @Override
    public E replace(UnsignedInteger key, E value) {
        return this.replace(key.intValue(), value);
    }

    @Override
    public E replace(int key, E value) {
        this.root = this.splay(this.root, key);
        if (this.root == null || this.root.key != key || this.root.value == null) {
            return null;
        }
        return this.root.setValue(value);
    }

    protected void entryAdded(SplayedEntry<E> newEntry) {
    }

    protected void entryDeleted(SplayedEntry<E> deletedEntry) {
    }

    private SplayedEntry<E> rightRotate(SplayedEntry<E> node) {
        SplayedEntry rotated = node.left;
        node.left = rotated.right;
        rotated.right = node;
        rotated.parent = node.parent;
        node.parent = rotated;
        if (node.left != null) {
            node.left.parent = node;
        }
        return rotated;
    }

    private SplayedEntry<E> leftRotate(SplayedEntry<E> node) {
        SplayedEntry rotated = node.right;
        node.right = rotated.left;
        rotated.left = node;
        rotated.parent = node.parent;
        node.parent = rotated;
        if (node.right != null) {
            node.right.parent = node;
        }
        return rotated;
    }

    private SplayedEntry<E> splay(SplayedEntry<E> root, int key) {
        if (root == null || root.key == key) {
            return root;
        }
        SplayedEntry lessThanKeyRoot = null;
        SplayedEntry<E> lessThanKeyNode = null;
        SplayedEntry<E> greaterThanKeyRoot = null;
        SplayedEntry<E> greaterThanKeyNode = null;
        while (true) {
            if (SplayMap.compare(key, root.key) < 0) {
                if (root.left != null && SplayMap.compare(key, root.left.key) < 0) {
                    root = this.rightRotate(root);
                }
                if (root.left == null) break;
                if (greaterThanKeyRoot == null) {
                    greaterThanKeyRoot = greaterThanKeyNode = root;
                } else {
                    greaterThanKeyNode.left = root;
                    greaterThanKeyNode.left.parent = greaterThanKeyNode;
                    greaterThanKeyNode = root;
                }
                root = root.left;
                root.parent = null;
                continue;
            }
            if (SplayMap.compare(key, root.key) <= 0) break;
            if (root.right != null && SplayMap.compare(key, root.right.key) > 0) {
                root = this.leftRotate(root);
            }
            if (root.right == null) break;
            if (lessThanKeyRoot == null) {
                lessThanKeyNode = root;
                lessThanKeyRoot = lessThanKeyNode;
            } else {
                lessThanKeyNode.right = root;
                lessThanKeyNode.right.parent = lessThanKeyNode;
                lessThanKeyNode = root;
            }
            root = root.right;
            root.parent = null;
        }
        if (lessThanKeyRoot == null) {
            lessThanKeyRoot = root.left;
        } else {
            lessThanKeyNode.right = root.left;
            if (lessThanKeyNode.right != null) {
                lessThanKeyNode.right.parent = lessThanKeyNode;
            }
        }
        if (greaterThanKeyRoot == null) {
            greaterThanKeyRoot = root.right;
        } else {
            greaterThanKeyNode.left = root.right;
            if (greaterThanKeyNode.left != null) {
                greaterThanKeyNode.left.parent = greaterThanKeyNode;
            }
        }
        root.left = lessThanKeyRoot;
        if (root.left != null) {
            root.left.parent = root;
        }
        root.right = greaterThanKeyRoot;
        if (root.right != null) {
            root.right.parent = root;
        }
        return root;
    }

    protected void delete(SplayedEntry<E> node) {
        SplayedEntry grandparent = node.parent;
        SplayedEntry replacement = node.right;
        if (node.left != null) {
            replacement = this.splay(node.left, node.key);
            replacement.right = node.right;
        }
        if (replacement != null) {
            replacement.parent = grandparent;
        }
        if (grandparent != null) {
            if (grandparent.left == node) {
                grandparent.left = replacement;
            } else {
                grandparent.right = replacement;
            }
        } else {
            this.root = replacement;
        }
        node.parent = null;
        node.right = null;
        node.left = null;
        this.entryPool.offer(node);
        this.entryDeleted(node);
        --this.size;
        ++this.modCount;
    }

    private SplayedEntry<E> firstEntry(SplayedEntry<E> node) {
        SplayedEntry<E> firstEntry = node;
        if (firstEntry != null) {
            while (firstEntry.left != null) {
                firstEntry = firstEntry.left;
            }
        }
        return firstEntry;
    }

    private SplayedEntry<E> lastEntry(SplayedEntry<E> node) {
        SplayedEntry<E> lastEntry = node;
        if (lastEntry != null) {
            while (lastEntry.right != null) {
                lastEntry = lastEntry.right;
            }
        }
        return lastEntry;
    }

    private SplayedEntry<E> successor(SplayedEntry<E> node) {
        if (node == null) {
            return null;
        }
        if (node.right != null) {
            SplayedEntry result = node.right;
            while (result.left != null) {
                result = result.left;
            }
            return result;
        }
        SplayedEntry parent = node.parent;
        SplayedEntry<E> child = node;
        while (parent != null && child == parent.right) {
            child = parent;
            parent = parent.parent;
        }
        return parent;
    }

    private SplayedEntry<E> predecessor(SplayedEntry<E> node) {
        if (node == null) {
            return null;
        }
        if (node.left != null) {
            SplayedEntry result = node.left;
            while (result.right != null) {
                result = result.right;
            }
            return result;
        }
        SplayedEntry parent = node.parent;
        SplayedEntry<E> child = node;
        while (parent != null && child == parent.left) {
            child = parent;
            parent = parent.parent;
        }
        return parent;
    }

    private static int compare(int lhs, int rhs) {
        return Integer.compareUnsigned(lhs, rhs);
    }

    private static <E> SplayedEntry<E> createEntry() {
        return new SplayedEntry();
    }

    protected ImmutableSplayMapEntry export(SplayedEntry<E> entry) {
        return entry == null ? null : new ImmutableSplayMapEntry(entry);
    }

    @Override
    public Comparator<? super UnsignedInteger> comparator() {
        return COMPARATOR;
    }

    @Override
    public UnsignedInteger firstKey() {
        return this.isEmpty() ? null : this.firstEntry(this.root).getKey();
    }

    @Override
    public UnsignedInteger lastKey() {
        return this.isEmpty() ? null : this.lastEntry(this.root).getKey();
    }

    public ImmutableSplayMapEntry firstEntry() {
        return this.export(this.firstEntry(this.root));
    }

    public ImmutableSplayMapEntry lastEntry() {
        return this.export(this.lastEntry(this.root));
    }

    public ImmutableSplayMapEntry pollFirstEntry() {
        SplayedEntry<E> firstEntry = this.firstEntry(this.root);
        if (firstEntry != null) {
            this.delete(firstEntry);
        }
        return this.export(firstEntry);
    }

    public ImmutableSplayMapEntry pollLastEntry() {
        SplayedEntry<E> lastEntry = this.lastEntry(this.root);
        if (lastEntry != null) {
            this.delete(lastEntry);
        }
        return this.export(lastEntry);
    }

    public ImmutableSplayMapEntry lowerEntry(UnsignedInteger key) {
        return this.export(this.lowerEntry(key.intValue()));
    }

    @Override
    public UnsignedInteger lowerKey(UnsignedInteger key) {
        SplayedEntry<E> result = this.lowerEntry(key.intValue());
        return result == null ? null : result.getKey();
    }

    private SplayedEntry<E> lowerEntry(int key) {
        this.root = this.splay(this.root, key);
        while (this.root != null && SplayMap.compare(this.root.getIntKey(), key) >= 0) {
            this.root = this.predecessor(this.root);
        }
        return this.root;
    }

    public ImmutableSplayMapEntry higherEntry(UnsignedInteger key) {
        return this.export(this.higherEntry(key.intValue()));
    }

    @Override
    public UnsignedInteger higherKey(UnsignedInteger key) {
        SplayedEntry<E> result = this.higherEntry(key.intValue());
        return result == null ? null : result.getKey();
    }

    private SplayedEntry<E> higherEntry(int key) {
        this.root = this.splay(this.root, key);
        while (this.root != null && SplayMap.compare(this.root.getIntKey(), key) <= 0) {
            this.root = this.successor(this.root);
        }
        return this.root;
    }

    public ImmutableSplayMapEntry floorEntry(UnsignedInteger key) {
        return this.export(this.floorEntry(key.intValue()));
    }

    @Override
    public UnsignedInteger floorKey(UnsignedInteger key) {
        SplayedEntry<E> result = this.floorEntry(key.intValue());
        return result == null ? null : result.getKey();
    }

    private SplayedEntry<E> floorEntry(int key) {
        this.root = this.splay(this.root, key);
        while (this.root != null && SplayMap.compare(this.root.getIntKey(), key) > 0) {
            this.root = this.predecessor(this.root);
        }
        return this.root;
    }

    public ImmutableSplayMapEntry ceilingEntry(UnsignedInteger key) {
        return this.export(this.ceilingEntry(key.intValue()));
    }

    @Override
    public UnsignedInteger ceilingKey(UnsignedInteger key) {
        SplayedEntry<E> result = this.ceilingEntry(key.intValue());
        return result == null ? null : result.getKey();
    }

    private SplayedEntry<E> ceilingEntry(int key) {
        this.root = this.splay(this.root, key);
        while (this.root != null && SplayMap.compare(this.root.getIntKey(), key) < 0) {
            this.root = this.successor(this.root);
        }
        return this.root;
    }

    @Override
    public NavigableMap<UnsignedInteger, E> descendingMap() {
        return null;
    }

    @Override
    public NavigableSet<UnsignedInteger> navigableKeySet() {
        return null;
    }

    @Override
    public NavigableSet<UnsignedInteger> descendingKeySet() {
        return null;
    }

    @Override
    public NavigableMap<UnsignedInteger, E> subMap(UnsignedInteger fromKey, boolean fromInclusive, UnsignedInteger toKey, boolean toInclusive) {
        return null;
    }

    @Override
    public NavigableMap<UnsignedInteger, E> headMap(UnsignedInteger toKey, boolean inclusive) {
        return null;
    }

    @Override
    public NavigableMap<UnsignedInteger, E> tailMap(UnsignedInteger fromKey, boolean inclusive) {
        return null;
    }

    @Override
    public SortedMap<UnsignedInteger, E> subMap(UnsignedInteger fromKey, UnsignedInteger toKey) {
        return null;
    }

    @Override
    public SortedMap<UnsignedInteger, E> headMap(UnsignedInteger toKey) {
        return null;
    }

    @Override
    public SortedMap<UnsignedInteger, E> tailMap(UnsignedInteger fromKey) {
        return null;
    }

    private static final class UnsignedComparator
    implements Comparator<UnsignedInteger> {
        private UnsignedComparator() {
        }

        @Override
        public int compare(UnsignedInteger uint1, UnsignedInteger uint2) {
            return uint1.compareTo(uint2);
        }
    }

    public class ImmutableSplayMapEntry
    implements Map.Entry<UnsignedInteger, E> {
        private final SplayedEntry<E> entry;

        public ImmutableSplayMapEntry(SplayedEntry<E> entry) {
            this.entry = entry;
        }

        @Override
        public UnsignedInteger getKey() {
            return this.entry.getKey();
        }

        public int getPrimitiveKey() {
            return this.entry.getIntKey();
        }

        @Override
        public E getValue() {
            return this.entry.getValue();
        }

        @Override
        public E setValue(E value) {
            throw new UnsupportedOperationException();
        }
    }

    protected static final class SplayedEntry<E>
    implements Map.Entry<UnsignedInteger, E> {
        SplayedEntry<E> left;
        SplayedEntry<E> right;
        SplayedEntry<E> parent;
        int key;
        E value;
        SplayedEntry<E> linkNext;
        SplayedEntry<E> linkPrev;

        public SplayedEntry() {
            this.initialize(this.key, this.value);
        }

        public SplayedEntry<E> initialize(int key, E value) {
            this.key = key;
            this.value = value;
            this.linkNext = this;
            this.linkPrev = this;
            return this;
        }

        public int getIntKey() {
            return this.key;
        }

        @Override
        public UnsignedInteger getKey() {
            return UnsignedInteger.valueOf(this.key);
        }

        @Override
        public E getValue() {
            return this.value;
        }

        @Override
        public E setValue(E value) {
            E oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.keyEquals(e.getKey()) && this.valueEquals(e.getValue());
        }

        @Override
        public int hashCode() {
            return this.key ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return "Node:{" + this.key + "," + this.value + "}";
        }

        boolean keyEquals(Object other) {
            if (!(other instanceof Number)) {
                return false;
            }
            return this.key == ((Number)other).intValue();
        }

        boolean valueEquals(Object other) {
            return this.value != null ? this.value.equals(other) : other == null;
        }
    }

    private final class SplayMapEntrySet
    extends AbstractSet<Map.Entry<UnsignedInteger, E>> {
        private SplayMapEntrySet() {
        }

        @Override
        public Iterator<Map.Entry<UnsignedInteger, E>> iterator() {
            return new SplayMapEntryIterator(SplayMap.this.firstEntry(SplayMap.this.root));
        }

        @Override
        public int size() {
            return SplayMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry) || SplayMap.this.root == null) {
                return false;
            }
            SplayedEntry e = SplayMap.this.firstEntry(SplayMap.this.root);
            while (e != null) {
                if (e.equals(o)) {
                    return true;
                }
                e = SplayMap.this.successor(e);
            }
            return false;
        }

        @Override
        public boolean remove(Object target) {
            if (!(target instanceof Map.Entry)) {
                throw new IllegalArgumentException("value provided is not an Entry type.");
            }
            SplayedEntry e = SplayMap.this.firstEntry(SplayMap.this.root);
            while (e != null) {
                if (e.equals(target)) {
                    SplayMap.this.delete(e);
                    return true;
                }
                e = SplayMap.this.successor(e);
            }
            return false;
        }

        @Override
        public void clear() {
            SplayMap.this.clear();
        }
    }

    private final class SplayMapKeySet
    extends AbstractSet<UnsignedInteger> {
        private SplayMapKeySet() {
        }

        @Override
        public Iterator<UnsignedInteger> iterator() {
            return new SplayMapKeyIterator(SplayMap.this.firstEntry(SplayMap.this.root));
        }

        @Override
        public int size() {
            return SplayMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return SplayMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object target) {
            SplayedEntry e = SplayMap.this.firstEntry(SplayMap.this.root);
            while (e != null) {
                if (e.keyEquals(target)) {
                    SplayMap.this.delete(e);
                    return true;
                }
                e = SplayMap.this.successor(e);
            }
            return false;
        }

        @Override
        public void clear() {
            SplayMap.this.clear();
        }
    }

    private final class SplayMapValues
    extends AbstractCollection<E> {
        private SplayMapValues() {
        }

        @Override
        public Iterator<E> iterator() {
            return new SplayMapValueIterator(SplayMap.this.firstEntry(SplayMap.this.root));
        }

        @Override
        public int size() {
            return SplayMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return SplayMap.this.containsValue(o);
        }

        @Override
        public boolean remove(Object target) {
            SplayedEntry e = SplayMap.this.firstEntry(SplayMap.this.root);
            while (e != null) {
                if (e.valueEquals(target)) {
                    SplayMap.this.delete(e);
                    return true;
                }
                e = SplayMap.this.successor(e);
            }
            return false;
        }

        @Override
        public void clear() {
            SplayMap.this.clear();
        }
    }

    private class SplayMapValueIterator
    extends SplayMapIterator<E> {
        public SplayMapValueIterator(SplayedEntry<E> startAt) {
            super(startAt);
        }

        @Override
        public E next() {
            return this.nextNode().getValue();
        }
    }

    private class SplayMapKeyIterator
    extends SplayMapIterator<UnsignedInteger> {
        public SplayMapKeyIterator(SplayedEntry<E> startAt) {
            super(startAt);
        }

        @Override
        public UnsignedInteger next() {
            return this.nextNode().getKey();
        }
    }

    private class SplayMapEntryIterator
    extends SplayMapIterator<Map.Entry<UnsignedInteger, E>> {
        public SplayMapEntryIterator(SplayedEntry<E> startAt) {
            super(startAt);
        }

        @Override
        public Map.Entry<UnsignedInteger, E> next() {
            return this.nextNode();
        }
    }

    private abstract class SplayMapIterator<T>
    implements Iterator<T> {
        private SplayedEntry<E> nextNode;
        private SplayedEntry<E> lastReturned;
        private int expectedModCount;

        public SplayMapIterator(SplayedEntry<E> startAt) {
            this.nextNode = startAt;
            this.expectedModCount = SplayMap.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        protected SplayedEntry<E> nextNode() {
            SplayedEntry entry = this.nextNode;
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            if (this.expectedModCount != SplayMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            this.nextNode = SplayMap.this.successor(this.nextNode);
            this.lastReturned = entry;
            return this.lastReturned;
        }

        protected SplayedEntry<E> previousNode() {
            SplayedEntry entry = this.nextNode;
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            if (this.expectedModCount != SplayMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            this.nextNode = SplayMap.this.predecessor(this.nextNode);
            this.lastReturned = entry;
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (SplayMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            SplayMap.this.delete(this.lastReturned);
            this.expectedModCount = SplayMap.this.modCount;
            this.lastReturned = null;
        }
    }
}

