/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.engine.sasl.client;

import java.nio.charset.StandardCharsets;
import javax.security.sasl.SaslException;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonByteBufferAllocator;
import org.apache.qpid.protonj2.engine.sasl.client.AbstractMechanism;
import org.apache.qpid.protonj2.engine.sasl.client.SaslCredentialsProvider;
import org.apache.qpid.protonj2.types.Symbol;

public class PlainMechanism
extends AbstractMechanism {
    public static final Symbol PLAIN = Symbol.valueOf("PLAIN");

    @Override
    public Symbol getName() {
        return PLAIN;
    }

    @Override
    public boolean isApplicable(SaslCredentialsProvider credentials) {
        return credentials.username() != null && !credentials.username().isEmpty() && credentials.password() != null && !credentials.password().isEmpty();
    }

    @Override
    public ProtonBuffer getInitialResponse(SaslCredentialsProvider credentials) throws SaslException {
        String username = credentials.username();
        String password = credentials.password();
        if (username == null) {
            username = "";
        }
        if (password == null) {
            password = "";
        }
        byte[] usernameBytes = username.getBytes(StandardCharsets.UTF_8);
        byte[] passwordBytes = password.getBytes(StandardCharsets.UTF_8);
        byte[] data = new byte[usernameBytes.length + passwordBytes.length + 2];
        System.arraycopy(usernameBytes, 0, data, 1, usernameBytes.length);
        System.arraycopy(passwordBytes, 0, data, 2 + usernameBytes.length, passwordBytes.length);
        return ProtonByteBufferAllocator.DEFAULT.wrap(data).setWriteIndex(data.length);
    }
}

