/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.engine.impl;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.engine.exceptions.ProtocolViolationException;
import org.apache.qpid.protonj2.engine.impl.ProtonEngine;
import org.apache.qpid.protonj2.engine.impl.ProtonIncomingDelivery;
import org.apache.qpid.protonj2.engine.impl.ProtonLink;
import org.apache.qpid.protonj2.engine.impl.ProtonReceiver;
import org.apache.qpid.protonj2.engine.impl.ProtonSession;
import org.apache.qpid.protonj2.engine.util.SequenceNumber;
import org.apache.qpid.protonj2.engine.util.SplayMap;
import org.apache.qpid.protonj2.types.UnsignedInteger;
import org.apache.qpid.protonj2.types.transport.Begin;
import org.apache.qpid.protonj2.types.transport.Disposition;
import org.apache.qpid.protonj2.types.transport.Flow;
import org.apache.qpid.protonj2.types.transport.Role;
import org.apache.qpid.protonj2.types.transport.Transfer;

public class ProtonSessionIncomingWindow {
    private static final long DEFAULT_WINDOW_SIZE = Integer.MAX_VALUE;
    private final ProtonSession session;
    private final ProtonEngine engine;
    private int incomingCapacity = 0;
    private long incomingWindow = 0L;
    private long nextIncomingId = 0L;
    private SequenceNumber lastDeliveryid;
    private long maxFrameSize;
    private long incomingBytes;
    private SplayMap<ProtonIncomingDelivery> unsettled = new SplayMap();
    private final Disposition cachedDisposition = new Disposition();

    public ProtonSessionIncomingWindow(ProtonSession session) {
        this.session = session;
        this.engine = session.getConnection().getEngine();
        this.maxFrameSize = session.getConnection().getMaxFrameSize();
    }

    public void setIncomingCapacity(int incomingCapacity) {
        this.incomingCapacity = incomingCapacity;
    }

    public int getIncomingCapacity() {
        return this.incomingCapacity;
    }

    public int getRemainingIncomingCapacity() {
        if (this.incomingCapacity <= 0 || this.maxFrameSize == UnsignedInteger.MAX_VALUE.longValue()) {
            return Integer.MAX_VALUE;
        }
        return (int)((long)this.incomingCapacity - this.incomingBytes);
    }

    Begin configureOutbound(Begin begin) {
        this.maxFrameSize = this.session.getConnection().getMaxFrameSize();
        return begin.setIncomingWindow(this.updateIncomingWindow());
    }

    Begin handleBegin(Begin begin) {
        if (begin.hasNextOutgoingId()) {
            this.nextIncomingId = begin.getNextOutgoingId();
        }
        return begin;
    }

    Flow handleFlow(Flow flow) {
        return flow;
    }

    Transfer handleTransfer(ProtonLink<?> link, Transfer transfer, ProtonBuffer payload) {
        this.incomingBytes += payload != null ? (long)payload.getReadableBytes() : 0L;
        --this.incomingWindow;
        ++this.nextIncomingId;
        ProtonIncomingDelivery delivery = link.remoteTransfer(transfer, payload);
        if (!delivery.isRemotelySettled() && delivery.isFirstTransfer()) {
            this.unsettled.put((int)delivery.getDeliveryId(), delivery);
        }
        return transfer;
    }

    Disposition handleDisposition(Disposition disposition) {
        int first = (int)disposition.getFirst();
        if (disposition.hasLast() && disposition.getLast() != (long)first) {
            this.handleRangedDisposition(disposition);
        } else {
            ProtonIncomingDelivery delivery;
            ProtonIncomingDelivery protonIncomingDelivery = delivery = disposition.getSettled() ? this.unsettled.remove(first) : this.unsettled.get(first);
            if (delivery != null) {
                delivery.getLink().remoteDisposition(disposition, delivery);
            }
        }
        return disposition;
    }

    private void handleRangedDisposition(Disposition disposition) {
        int first = (int)disposition.getFirst();
        int last = (int)disposition.getLast();
        boolean settled = disposition.getSettled();
        int index = first;
        do {
            ProtonIncomingDelivery delivery;
            ProtonIncomingDelivery protonIncomingDelivery = delivery = settled ? this.unsettled.remove(index) : this.unsettled.get(index);
            if (delivery == null) continue;
            delivery.getLink().remoteDisposition(disposition, delivery);
        } while (index++ != last);
    }

    long updateIncomingWindow() {
        this.incomingWindow = this.incomingCapacity <= 0 || this.maxFrameSize == UnsignedInteger.MAX_VALUE.longValue() ? Integer.MAX_VALUE : ((long)this.incomingCapacity - this.incomingBytes) / this.maxFrameSize;
        return this.incomingWindow;
    }

    void writeFlow(ProtonReceiver link) {
        this.updateIncomingWindow();
        this.session.writeFlow(link);
    }

    public long getIncomingBytes() {
        return this.incomingBytes;
    }

    public long getNextIncomingId() {
        return this.nextIncomingId;
    }

    public long getIncomingWindow() {
        return this.incomingWindow;
    }

    void processDisposition(ProtonReceiver receiver, ProtonIncomingDelivery delivery) {
        if (!delivery.isRemotelySettled()) {
            if (delivery.isSettled()) {
                this.unsettled.remove((int)delivery.getDeliveryId());
            }
            this.cachedDisposition.reset();
            this.cachedDisposition.setFirst(delivery.getDeliveryId());
            this.cachedDisposition.setRole(Role.RECEIVER);
            this.cachedDisposition.setSettled(delivery.isSettled());
            this.cachedDisposition.setState(delivery.getState());
            this.engine.fireWrite(this.cachedDisposition, this.session.getLocalChannel());
        }
    }

    void deliveryRead(ProtonIncomingDelivery delivery, int bytesRead) {
        this.incomingBytes -= (long)bytesRead;
        if (this.incomingWindow == 0L) {
            this.writeFlow(delivery.getLink());
        }
    }

    void validateNextDeliveryId(long deliveryId) {
        if (this.lastDeliveryid == null) {
            this.lastDeliveryid = new SequenceNumber((int)deliveryId);
        } else {
            int previousId = this.lastDeliveryid.intValue();
            if (this.lastDeliveryid.increment().compareTo((int)deliveryId) != 0) {
                this.session.getConnection().getEngine().engineFailed(new ProtocolViolationException("Expected delivery-id " + previousId + ", got " + deliveryId));
            }
        }
    }
}

