/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.engine.impl;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonByteBufferAllocator;
import org.apache.qpid.protonj2.codec.CodecFactory;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.Decoder;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.engine.AMQPPerformativeEnvelopePool;
import org.apache.qpid.protonj2.engine.EmptyEnvelope;
import org.apache.qpid.protonj2.engine.EngineHandler;
import org.apache.qpid.protonj2.engine.EngineHandlerContext;
import org.apache.qpid.protonj2.engine.HeaderEnvelope;
import org.apache.qpid.protonj2.engine.IncomingAMQPEnvelope;
import org.apache.qpid.protonj2.engine.SASLEnvelope;
import org.apache.qpid.protonj2.engine.exceptions.EngineFailedException;
import org.apache.qpid.protonj2.engine.exceptions.FrameDecodingException;
import org.apache.qpid.protonj2.engine.exceptions.MalformedAMQPHeaderException;
import org.apache.qpid.protonj2.engine.exceptions.ProtonException;
import org.apache.qpid.protonj2.engine.impl.ProtonEngine;
import org.apache.qpid.protonj2.engine.impl.ProtonEngineConfiguration;
import org.apache.qpid.protonj2.engine.impl.ProtonEngineHandlerContext;
import org.apache.qpid.protonj2.logging.ProtonLogger;
import org.apache.qpid.protonj2.logging.ProtonLoggerFactory;
import org.apache.qpid.protonj2.types.security.SaslOutcome;
import org.apache.qpid.protonj2.types.security.SaslPerformative;
import org.apache.qpid.protonj2.types.transport.AMQPHeader;
import org.apache.qpid.protonj2.types.transport.Performative;

public class ProtonFrameDecodingHandler
implements EngineHandler,
SaslPerformative.SaslPerformativeHandler<EngineHandlerContext> {
    private static final ProtonLogger LOG = ProtonLoggerFactory.getLogger(ProtonFrameDecodingHandler.class);
    public static final byte AMQP_FRAME_TYPE = 0;
    public static final byte SASL_FRAME_TYPE = 1;
    public static final int FRAME_SIZE_BYTES = 4;
    private final AMQPPerformativeEnvelopePool<IncomingAMQPEnvelope> framePool = AMQPPerformativeEnvelopePool.incomingEnvelopePool();
    private Decoder decoder;
    private DecoderState decoderState;
    private FrameParserStage stage = new HeaderParsingStage();
    private ProtonEngine engine;
    private ProtonEngineConfiguration configuration;
    private final FrameSizeParsingStage frameSizeParser = new FrameSizeParsingStage();
    private final FrameBufferingStage frameBufferingStage = new FrameBufferingStage();
    private final FrameBodyParsingStage frameBodyParsingStage = new FrameBodyParsingStage();

    @Override
    public void handlerAdded(EngineHandlerContext context) {
        this.engine = (ProtonEngine)context.engine();
        this.configuration = this.engine.configuration();
    }

    @Override
    public void engineFailed(EngineHandlerContext context, EngineFailedException failure) {
        this.transitionToErrorStage(failure);
        context.fireFailed(failure);
    }

    @Override
    public void handleRead(EngineHandlerContext context, ProtonBuffer buffer) {
        try {
            while (buffer.isReadable() && this.engine.isWritable()) {
                this.stage.parse(context, buffer);
            }
        }
        catch (FrameDecodingException frameEx) {
            this.transitionToErrorStage(frameEx).fireError(context);
        }
        catch (ProtonException pex) {
            this.transitionToErrorStage(pex).fireError(context);
        }
        catch (DecodeException ex) {
            this.transitionToErrorStage(new FrameDecodingException(ex.getMessage(), (Throwable)ex)).fireError(context);
        }
        catch (Exception error) {
            this.transitionToErrorStage(new ProtonException(error.getMessage(), error)).fireError(context);
        }
    }

    @Override
    public void handleRead(EngineHandlerContext context, SASLEnvelope envelope) {
        ((SaslPerformative)envelope.getBody()).invoke(this, context);
        context.fireRead(envelope);
    }

    @Override
    public void handleWrite(EngineHandlerContext context, SASLEnvelope envelope) {
        envelope.invoke(this, context);
        context.fireWrite(envelope);
    }

    @Override
    public void handleOutcome(SaslOutcome saslOutcome, EngineHandlerContext context) {
        this.stage = new HeaderParsingStage();
    }

    private FrameParserStage transitionToFrameSizeParsingStage() {
        this.stage = this.frameSizeParser.reset(0);
        return this.stage;
    }

    private FrameParserStage transitionToFrameBufferingStage(int length) {
        this.stage = this.frameBufferingStage.reset(length);
        return this.stage;
    }

    private FrameParserStage initializeFrameBodyParsingStage(int length) {
        this.stage = this.frameBodyParsingStage.reset(length);
        return this.stage;
    }

    private ParsingErrorStage transitionToErrorStage(ProtonException error) {
        if (!(this.stage instanceof ParsingErrorStage)) {
            LOG.trace("Frame decoder encountered error: ", (Object)error);
            this.stage = new ParsingErrorStage(error);
        }
        return (ParsingErrorStage)this.stage;
    }

    private static class ParsingErrorStage
    implements FrameParserStage {
        private final ProtonException parsingError;

        public ParsingErrorStage(ProtonException parsingError) {
            this.parsingError = parsingError;
        }

        public void fireError(EngineHandlerContext context) {
            throw this.parsingError;
        }

        @Override
        public void parse(EngineHandlerContext context, ProtonBuffer input) {
            throw new FrameDecodingException(this.parsingError);
        }

        @Override
        public ParsingErrorStage reset(int length) {
            return this;
        }
    }

    private class FrameBodyParsingStage
    implements FrameParserStage {
        private int length;

        private FrameBodyParsingStage() {
        }

        @Override
        public void parse(EngineHandlerContext context, ProtonBuffer input) {
            int dataOffset = input.readByte() << 2 & 0x3FF;
            int frameSize = this.length + 4;
            this.validateDataOffset(dataOffset, frameSize);
            int type = input.readByte() & 0xFF;
            short channel = input.readShort();
            if (dataOffset != 8) {
                input.setReadIndex(input.getReadIndex() + dataOffset - 8);
            }
            int frameBodySize = frameSize - dataOffset;
            ProtonBuffer payload = null;
            Object val = null;
            if (frameBodySize > 0) {
                int payloadSize;
                int startReadIndex = input.getReadIndex();
                val = ProtonFrameDecodingHandler.this.decoder.readObject(input, ProtonFrameDecodingHandler.this.decoderState);
                if (input.isReadable() && (payloadSize = frameBodySize - (input.getReadIndex() - startReadIndex)) > 0) {
                    payload = ProtonFrameDecodingHandler.this.configuration.getBufferAllocator().allocate(payloadSize, payloadSize);
                    payload.writeBytes(input, payloadSize);
                }
            } else {
                ProtonFrameDecodingHandler.this.transitionToFrameSizeParsingStage();
                context.fireRead(EmptyEnvelope.INSTANCE);
                return;
            }
            if (type == 0) {
                Performative performative = (Performative)val;
                IncomingAMQPEnvelope frame = ProtonFrameDecodingHandler.this.framePool.take(performative, channel, payload);
                ProtonFrameDecodingHandler.this.transitionToFrameSizeParsingStage();
                context.fireRead(frame);
            } else if (type == 1) {
                SaslPerformative performative = (SaslPerformative)val;
                SASLEnvelope saslFrame = new SASLEnvelope(performative);
                ProtonFrameDecodingHandler.this.transitionToFrameSizeParsingStage();
                ProtonFrameDecodingHandler.this.handleRead(context, saslFrame);
            } else {
                throw new FrameDecodingException(String.format("unknown frame type: %d", type));
            }
        }

        private void validateDataOffset(int dataOffset, int frameSize) throws FrameDecodingException {
            if (dataOffset < 8) {
                throw new FrameDecodingException(String.format("specified frame data offset %d smaller than minimum frame header size %d", dataOffset, 8));
            }
            if (dataOffset > frameSize) {
                throw new FrameDecodingException(String.format("specified frame data offset %d larger than the frame size %d", dataOffset, frameSize));
            }
        }

        @Override
        public FrameBodyParsingStage reset(int length) {
            this.length = length;
            return this;
        }
    }

    private class FrameBufferingStage
    implements FrameParserStage {
        private ProtonBuffer buffer;

        private FrameBufferingStage() {
        }

        @Override
        public void parse(EngineHandlerContext context, ProtonBuffer input) {
            if (input.getReadableBytes() < this.buffer.getWritableBytes()) {
                this.buffer.writeBytes(input);
            } else {
                this.buffer.writeBytes(input, this.buffer.getWritableBytes());
                ProtonFrameDecodingHandler.this.initializeFrameBodyParsingStage(this.buffer.getReadableBytes());
                try {
                    ProtonFrameDecodingHandler.this.stage.parse(context, this.buffer);
                }
                finally {
                    this.buffer = null;
                }
            }
        }

        @Override
        public FrameBufferingStage reset(int length) {
            this.buffer = ProtonByteBufferAllocator.DEFAULT.allocate(length, length);
            return this;
        }
    }

    private class FrameSizeParsingStage
    implements FrameParserStage {
        private int frameSize;
        private int multiplier = 4;

        private FrameSizeParsingStage() {
        }

        @Override
        public void parse(EngineHandlerContext context, ProtonBuffer input) {
            while (input.isReadable()) {
                this.frameSize |= (input.readByte() & 0xFF) << --this.multiplier * 8;
                if (this.multiplier != 0) continue;
            }
            if (this.multiplier == 0) {
                this.validateFrameSize();
                int length = this.frameSize - 4;
                if (input.getReadableBytes() < length) {
                    ProtonFrameDecodingHandler.this.transitionToFrameBufferingStage(length);
                } else {
                    ProtonFrameDecodingHandler.this.initializeFrameBodyParsingStage(length);
                }
                ProtonFrameDecodingHandler.this.stage.parse(context, input);
            }
        }

        private void validateFrameSize() throws FrameDecodingException {
            if (Integer.compareUnsigned(this.frameSize, 8) < 0) {
                throw new FrameDecodingException(String.format("specified frame size %d smaller than minimum frame header size 8", this.frameSize));
            }
            if (Integer.toUnsignedLong(this.frameSize) > ProtonFrameDecodingHandler.this.configuration.getInboundMaxFrameSize()) {
                throw new FrameDecodingException(String.format("specified frame size %s larger than maximum frame size %d", Integer.toUnsignedString(this.frameSize), ProtonFrameDecodingHandler.this.configuration.getInboundMaxFrameSize()));
            }
        }

        @Override
        public FrameSizeParsingStage reset(int frameSize) {
            this.multiplier = 4;
            this.frameSize = frameSize;
            return this;
        }
    }

    private class HeaderParsingStage
    implements FrameParserStage {
        private final byte[] headerBytes = new byte[8];
        private int headerByte;

        private HeaderParsingStage() {
        }

        @Override
        public void parse(EngineHandlerContext context, ProtonBuffer incoming) {
            while (incoming.isReadable() && this.headerByte < 8) {
                byte nextByte = incoming.readByte();
                try {
                    AMQPHeader.validateByte(this.headerByte, nextByte);
                }
                catch (IllegalArgumentException iae) {
                    throw new MalformedAMQPHeaderException(String.format("Error on validation of header byte %d with value of %d", this.headerByte, nextByte), (Throwable)iae);
                }
                this.headerBytes[this.headerByte++] = nextByte;
            }
            if (this.headerByte == 8) {
                AMQPHeader header = new AMQPHeader(this.headerBytes);
                ProtonFrameDecodingHandler.this.transitionToFrameSizeParsingStage();
                if (header.isSaslHeader()) {
                    ProtonFrameDecodingHandler.this.decoder = CodecFactory.getSaslDecoder();
                    ProtonFrameDecodingHandler.this.decoderState = ProtonFrameDecodingHandler.this.decoder.newDecoderState();
                    context.fireRead(HeaderEnvelope.SASL_HEADER_ENVELOPE);
                } else {
                    ProtonFrameDecodingHandler.this.decoder = CodecFactory.getDecoder();
                    ProtonFrameDecodingHandler.this.decoderState = ProtonFrameDecodingHandler.this.decoder.newDecoderState();
                    ((ProtonEngineHandlerContext)context).interestMask(2);
                    context.fireRead(HeaderEnvelope.AMQP_HEADER_ENVELOPE);
                }
            }
        }

        @Override
        public HeaderParsingStage reset(int frameSize) {
            this.headerByte = 0;
            return this;
        }
    }

    private static interface FrameParserStage {
        public void parse(EngineHandlerContext var1, ProtonBuffer var2);

        public FrameParserStage reset(int var1);
    }
}

