/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.transport;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.encoders.AbstractDescribedListTypeEncoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.transport.Transfer;

public final class TransferTypeEncoder
extends AbstractDescribedListTypeEncoder<Transfer> {
    @Override
    public UnsignedLong getDescriptorCode() {
        return Transfer.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Transfer.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Class<Transfer> getTypeClass() {
        return Transfer.class;
    }

    @Override
    public void writeElement(Transfer transfer, int index, ProtonBuffer buffer, EncoderState state) {
        switch (index) {
            case 0: {
                if (transfer.hasHandle()) {
                    state.getEncoder().writeUnsignedInteger(buffer, state, transfer.getHandle());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 1: {
                if (transfer.hasDeliveryId()) {
                    state.getEncoder().writeUnsignedInteger(buffer, state, transfer.getDeliveryId());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 2: {
                if (transfer.hasDeliveryTag()) {
                    state.getEncoder().writeDeliveryTag(buffer, state, transfer.getDeliveryTag());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 3: {
                if (transfer.hasMessageFormat()) {
                    state.getEncoder().writeUnsignedInteger(buffer, state, transfer.getMessageFormat());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 4: {
                if (transfer.hasSettled()) {
                    buffer.writeByte(transfer.getSettled() ? 65 : 66);
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 5: {
                if (transfer.hasMore()) {
                    buffer.writeByte(transfer.getMore() ? 65 : 66);
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 6: {
                if (transfer.hasRcvSettleMode()) {
                    state.getEncoder().writeUnsignedByte(buffer, state, transfer.getRcvSettleMode().byteValue());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 7: {
                state.getEncoder().writeObject(buffer, state, transfer.getState());
                break;
            }
            case 8: {
                if (transfer.hasResume()) {
                    buffer.writeByte(transfer.getResume() ? 65 : 66);
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 9: {
                if (transfer.hasAborted()) {
                    buffer.writeByte(transfer.getAborted() ? 65 : 66);
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 10: {
                if (transfer.hasBatchable()) {
                    buffer.writeByte(transfer.getBatchable() ? 65 : 66);
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Transfer value index: " + index);
            }
        }
    }

    @Override
    public byte getListEncoding(Transfer value) {
        if (value.getState() != null) {
            return -48;
        }
        if (value.getDeliveryTag() != null && value.getDeliveryTag().tagLength() > 200) {
            return -48;
        }
        return -64;
    }

    @Override
    public int getElementCount(Transfer transfer) {
        return transfer.getElementCount();
    }

    @Override
    public int getMinElementCount() {
        return 1;
    }
}

