/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.transport;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.encoders.AbstractDescribedListTypeEncoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.transport.Open;

public final class OpenTypeEncoder
extends AbstractDescribedListTypeEncoder<Open> {
    @Override
    public UnsignedLong getDescriptorCode() {
        return Open.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Open.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Class<Open> getTypeClass() {
        return Open.class;
    }

    @Override
    public void writeElement(Open open, int index, ProtonBuffer buffer, EncoderState state) {
        switch (index) {
            case 0: {
                if (open.hasContainerId()) {
                    state.getEncoder().writeString(buffer, state, open.getContainerId());
                    break;
                }
                state.getEncoder().writeNull(buffer, state);
                break;
            }
            case 1: {
                if (open.hasHostname()) {
                    state.getEncoder().writeString(buffer, state, open.getHostname());
                    break;
                }
                state.getEncoder().writeNull(buffer, state);
                break;
            }
            case 2: {
                if (open.hasMaxFrameSize()) {
                    state.getEncoder().writeUnsignedInteger(buffer, state, open.getMaxFrameSize());
                    break;
                }
                state.getEncoder().writeNull(buffer, state);
                break;
            }
            case 3: {
                if (open.hasChannelMax()) {
                    state.getEncoder().writeUnsignedShort(buffer, state, open.getChannelMax());
                    break;
                }
                state.getEncoder().writeNull(buffer, state);
                break;
            }
            case 4: {
                if (open.hasIdleTimeout()) {
                    state.getEncoder().writeUnsignedInteger(buffer, state, open.getIdleTimeout());
                    break;
                }
                state.getEncoder().writeNull(buffer, state);
                break;
            }
            case 5: {
                if (open.hasOutgoingLocales()) {
                    state.getEncoder().writeArray(buffer, state, open.getOutgoingLocales());
                    break;
                }
                state.getEncoder().writeNull(buffer, state);
                break;
            }
            case 6: {
                if (open.hasIncomingLocales()) {
                    state.getEncoder().writeArray(buffer, state, open.getIncomingLocales());
                    break;
                }
                state.getEncoder().writeNull(buffer, state);
                break;
            }
            case 7: {
                if (open.hasOfferedCapabilities()) {
                    state.getEncoder().writeArray(buffer, state, open.getOfferedCapabilities());
                    break;
                }
                state.getEncoder().writeNull(buffer, state);
                break;
            }
            case 8: {
                if (open.hasDesiredCapabilities()) {
                    state.getEncoder().writeArray(buffer, state, open.getDesiredCapabilities());
                    break;
                }
                state.getEncoder().writeNull(buffer, state);
                break;
            }
            case 9: {
                if (open.hasProperties()) {
                    state.getEncoder().writeMap(buffer, state, open.getProperties());
                    break;
                }
                state.getEncoder().writeNull(buffer, state);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Open value index: " + index);
            }
        }
    }

    @Override
    public byte getListEncoding(Open value) {
        return -48;
    }

    @Override
    public int getElementCount(Open open) {
        return open.getElementCount();
    }

    @Override
    public int getMinElementCount() {
        return 1;
    }
}

