/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.transport;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.encoders.AbstractDescribedListTypeEncoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.transport.Flow;

public final class FlowTypeEncoder
extends AbstractDescribedListTypeEncoder<Flow> {
    @Override
    public UnsignedLong getDescriptorCode() {
        return Flow.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Flow.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Class<Flow> getTypeClass() {
        return Flow.class;
    }

    @Override
    public void writeElement(Flow flow, int index, ProtonBuffer buffer, EncoderState state) {
        switch (index) {
            case 0: {
                if (flow.hasNextIncomingId()) {
                    state.getEncoder().writeUnsignedInteger(buffer, state, flow.getNextIncomingId());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 1: {
                if (flow.hasIncomingWindow()) {
                    state.getEncoder().writeUnsignedInteger(buffer, state, flow.getIncomingWindow());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 2: {
                if (flow.hasNextOutgoingId()) {
                    state.getEncoder().writeUnsignedInteger(buffer, state, flow.getNextOutgoingId());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 3: {
                if (flow.hasOutgoingWindow()) {
                    state.getEncoder().writeUnsignedInteger(buffer, state, flow.getOutgoingWindow());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 4: {
                if (flow.hasHandle()) {
                    state.getEncoder().writeUnsignedInteger(buffer, state, flow.getHandle());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 5: {
                if (flow.hasDeliveryCount()) {
                    state.getEncoder().writeUnsignedInteger(buffer, state, flow.getDeliveryCount());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 6: {
                if (flow.hasLinkCredit()) {
                    state.getEncoder().writeUnsignedInteger(buffer, state, flow.getLinkCredit());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 7: {
                if (flow.hasAvailable()) {
                    state.getEncoder().writeUnsignedInteger(buffer, state, flow.getAvailable());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 8: {
                if (flow.hasDrain()) {
                    buffer.writeByte(flow.getDrain() ? 65 : 66);
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 9: {
                if (flow.hasEcho()) {
                    buffer.writeByte(flow.getEcho() ? 65 : 66);
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 10: {
                state.getEncoder().writeMap(buffer, state, flow.getProperties());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Flow value index: " + index);
            }
        }
    }

    @Override
    public byte getListEncoding(Flow value) {
        if (value.getProperties() == null) {
            return -64;
        }
        return -48;
    }

    @Override
    public int getElementCount(Flow flow) {
        return flow.getElementCount();
    }

    @Override
    public int getMinElementCount() {
        return 4;
    }
}

