/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.transport;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.encoders.AbstractDescribedListTypeEncoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.transport.Attach;

public final class AttachTypeEncoder
extends AbstractDescribedListTypeEncoder<Attach> {
    @Override
    public UnsignedLong getDescriptorCode() {
        return Attach.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Attach.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Class<Attach> getTypeClass() {
        return Attach.class;
    }

    @Override
    public void writeElement(Attach attach, int index, ProtonBuffer buffer, EncoderState state) {
        switch (index) {
            case 0: {
                if (attach.hasName()) {
                    state.getEncoder().writeString(buffer, state, attach.getName());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 1: {
                if (attach.hasHandle()) {
                    state.getEncoder().writeUnsignedInteger(buffer, state, attach.getHandle());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 2: {
                if (attach.hasRole()) {
                    buffer.writeByte(attach.getRole().getValue() ? 65 : 66);
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 3: {
                if (attach.hasSenderSettleMode()) {
                    state.getEncoder().writeUnsignedByte(buffer, state, attach.getSenderSettleMode().byteValue());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 4: {
                if (attach.hasReceiverSettleMode()) {
                    state.getEncoder().writeUnsignedByte(buffer, state, attach.getReceiverSettleMode().byteValue());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 5: {
                if (attach.hasSource()) {
                    state.getEncoder().writeObject(buffer, state, attach.getSource());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 6: {
                if (attach.hasTargetOrCoordinator()) {
                    state.getEncoder().writeObject(buffer, state, attach.getTarget());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 7: {
                if (attach.hasUnsettled()) {
                    state.getEncoder().writeMap(buffer, state, attach.getUnsettled());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 8: {
                if (attach.hasIncompleteUnsettled()) {
                    buffer.writeByte(attach.getIncompleteUnsettled() ? 65 : 66);
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 9: {
                if (attach.hasInitialDeliveryCount()) {
                    state.getEncoder().writeUnsignedInteger(buffer, state, attach.getInitialDeliveryCount());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 10: {
                if (attach.hasMaxMessageSize()) {
                    state.getEncoder().writeUnsignedLong(buffer, state, attach.getMaxMessageSize());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 11: {
                if (attach.hasOfferedCapabilities()) {
                    state.getEncoder().writeArray(buffer, state, attach.getOfferedCapabilities());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 12: {
                if (attach.hasDesiredCapabilities()) {
                    state.getEncoder().writeArray(buffer, state, attach.getDesiredCapabilities());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            case 13: {
                if (attach.hasProperties()) {
                    state.getEncoder().writeMap(buffer, state, attach.getProperties());
                    break;
                }
                buffer.writeByte(64);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Attach value index: " + index);
            }
        }
    }

    @Override
    public byte getListEncoding(Attach value) {
        return -48;
    }

    @Override
    public int getElementCount(Attach attach) {
        return attach.getElementCount();
    }

    @Override
    public int getMinElementCount() {
        return 3;
    }
}

