/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.transactions;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.encoders.AbstractDescribedListTypeEncoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.transactions.Discharge;

public final class DischargeTypeEncoder
extends AbstractDescribedListTypeEncoder<Discharge> {
    @Override
    public UnsignedLong getDescriptorCode() {
        return Discharge.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Discharge.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Class<Discharge> getTypeClass() {
        return Discharge.class;
    }

    @Override
    public void writeElement(Discharge discharge, int index, ProtonBuffer buffer, EncoderState state) {
        switch (index) {
            case 0: {
                state.getEncoder().writeBinary(buffer, state, discharge.getTxnId());
                break;
            }
            case 1: {
                buffer.writeByte(discharge.getFail() ? 65 : 66);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Discharge value index: " + index);
            }
        }
    }

    @Override
    public byte getListEncoding(Discharge value) {
        if (value.getTxnId() != null && value.getTxnId().getLength() > 240) {
            return -48;
        }
        return -64;
    }

    @Override
    public int getElementCount(Discharge discharge) {
        return 2;
    }

    @Override
    public int getMinElementCount() {
        return 1;
    }
}

