/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.primitives;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.encoders.AbstractPrimitiveTypeEncoder;
import org.apache.qpid.protonj2.types.UnsignedLong;

public final class UnsignedLongTypeEncoder
extends AbstractPrimitiveTypeEncoder<UnsignedLong> {
    @Override
    public Class<UnsignedLong> getTypeClass() {
        return UnsignedLong.class;
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, UnsignedLong value) {
        this.writeType(buffer, state, value.longValue());
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, long value) {
        if (value == 0L) {
            buffer.writeByte(68);
        } else if (value > 0L && value <= 255L) {
            buffer.writeByte(83);
            buffer.writeByte((int)value);
        } else {
            buffer.writeByte(-128);
            buffer.writeLong(value);
        }
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, byte value) {
        if (value == 0) {
            buffer.writeByte(68);
        } else {
            buffer.writeByte(83);
            buffer.writeByte(value);
        }
    }

    @Override
    public void writeRawArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte(-128);
        for (Object value : values) {
            buffer.writeLong(((UnsignedLong)value).longValue());
        }
    }
}

