/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.primitives;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.encoders.AbstractPrimitiveTypeEncoder;

public final class StringTypeEncoder
extends AbstractPrimitiveTypeEncoder<String> {
    @Override
    public Class<String> getTypeClass() {
        return String.class;
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, String value) {
        if (value.length() > 64) {
            StringTypeEncoder.writeString(buffer, state, value);
        } else {
            StringTypeEncoder.writeSmallString(buffer, state, value);
        }
    }

    private static void writeSmallString(ProtonBuffer buffer, EncoderState state, String value) {
        buffer.writeByte(-95);
        buffer.writeByte(0);
        int startIndex = buffer.getWriteIndex();
        state.encodeUTF8(buffer, value);
        buffer.setByte(startIndex - 1, buffer.getWriteIndex() - startIndex);
    }

    private static void writeString(ProtonBuffer buffer, EncoderState state, String value) {
        buffer.writeByte(-79);
        buffer.writeInt(0);
        int startIndex = buffer.getWriteIndex();
        state.encodeUTF8(buffer, value);
        buffer.setInt(startIndex - 4, buffer.getWriteIndex() - startIndex);
    }

    @Override
    public void writeRawArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte(-79);
        for (Object value : values) {
            buffer.writeInt(0);
            int stringStart = buffer.getWriteIndex();
            state.encodeUTF8(buffer, (CharSequence)value);
            buffer.setInt(stringStart - 4, buffer.getWriteIndex() - stringStart);
        }
    }
}

