/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.primitives;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.encoders.AbstractPrimitiveTypeEncoder;

public final class ShortTypeEncoder
extends AbstractPrimitiveTypeEncoder<Short> {
    @Override
    public Class<Short> getTypeClass() {
        return Short.class;
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, Short value) {
        buffer.writeByte(97);
        buffer.writeShort(value);
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, short value) {
        buffer.writeByte(97);
        buffer.writeShort(value);
    }

    @Override
    public void writeRawArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte(97);
        for (Object value : values) {
            buffer.writeShort((Short)value);
        }
    }

    public void writeRawArray(ProtonBuffer buffer, EncoderState state, short[] values) {
        buffer.writeByte(97);
        for (short value : values) {
            buffer.writeShort(value);
        }
    }

    public void writeArray(ProtonBuffer buffer, EncoderState state, short[] values) {
        if (values.length < 127) {
            this.writeAsArray8(buffer, state, values);
        } else {
            this.writeAsArray32(buffer, state, values);
        }
    }

    private void writeAsArray8(ProtonBuffer buffer, EncoderState state, short[] values) {
        buffer.writeByte(-32);
        int startIndex = buffer.getWriteIndex();
        buffer.writeByte(0);
        buffer.writeByte(values.length);
        this.writeRawArray(buffer, state, values);
        int endIndex = buffer.getWriteIndex();
        long writeSize = endIndex - startIndex - 1;
        buffer.setByte(startIndex, (byte)writeSize);
    }

    private void writeAsArray32(ProtonBuffer buffer, EncoderState state, short[] values) {
        buffer.writeByte(-16);
        int startIndex = buffer.getWriteIndex();
        buffer.writeInt(0);
        buffer.writeInt(values.length);
        this.writeRawArray(buffer, state, values);
        int endIndex = buffer.getWriteIndex();
        long writeSize = endIndex - startIndex - 4;
        if (writeSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot encode given array, encoded size to large: " + writeSize);
        }
        buffer.setInt(startIndex, (int)writeSize);
    }
}

