/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.primitives;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.encoders.AbstractPrimitiveTypeEncoder;

public final class BooleanTypeEncoder
extends AbstractPrimitiveTypeEncoder<Boolean> {
    @Override
    public Class<Boolean> getTypeClass() {
        return Boolean.class;
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, Boolean value) {
        buffer.writeByte(value == Boolean.TRUE ? 65 : 66);
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, boolean value) {
        buffer.writeByte(value ? 65 : 66);
    }

    @Override
    public void writeRawArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte(86);
        for (Object bool : values) {
            buffer.writeByte((Boolean)bool != false ? 1 : 0);
        }
    }

    public void writeRawArray(ProtonBuffer buffer, EncoderState state, boolean[] values) {
        buffer.writeByte(86);
        for (boolean bool : values) {
            buffer.writeByte(bool ? 1 : 0);
        }
    }

    public void writeArray(ProtonBuffer buffer, EncoderState state, boolean[] values) {
        if (values.length < 254) {
            this.writeAsArray8(buffer, state, values);
        } else {
            this.writeAsArray32(buffer, state, values);
        }
    }

    private void writeAsArray8(ProtonBuffer buffer, EncoderState state, boolean[] values) {
        buffer.writeByte(-32);
        int startIndex = buffer.getWriteIndex();
        buffer.writeByte(0);
        buffer.writeByte(values.length);
        this.writeRawArray(buffer, state, values);
        int endIndex = buffer.getWriteIndex();
        long writeSize = endIndex - startIndex - 1;
        buffer.setByte(startIndex, (byte)writeSize);
    }

    private void writeAsArray32(ProtonBuffer buffer, EncoderState state, boolean[] values) {
        buffer.writeByte(-16);
        int startIndex = buffer.getWriteIndex();
        buffer.writeInt(0);
        buffer.writeInt(values.length);
        this.writeRawArray(buffer, state, values);
        int endIndex = buffer.getWriteIndex();
        long writeSize = endIndex - startIndex - 4;
        if (writeSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot encode given array, encoded size to large: " + writeSize);
        }
        buffer.setInt(startIndex, (int)writeSize);
    }
}

