/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.primitives;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.encoders.AbstractPrimitiveTypeEncoder;
import org.apache.qpid.protonj2.types.Binary;

public final class BinaryTypeEncoder
extends AbstractPrimitiveTypeEncoder<Binary> {
    @Override
    public Class<Binary> getTypeClass() {
        return Binary.class;
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, Binary value) {
        this.writeType(buffer, state, value.asProtonBuffer());
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, ProtonBuffer value) {
        if (value.getReadableBytes() > 255) {
            buffer.writeByte(-80);
            buffer.writeInt(value.getReadableBytes());
        } else {
            buffer.writeByte(-96);
            buffer.writeByte((byte)value.getReadableBytes());
        }
        if (value.hasArray()) {
            buffer.writeBytes(value.getArray(), value.getArrayOffset() + value.getReadIndex(), value.getReadableBytes());
        } else {
            buffer.writeBytes(value, value.getReadIndex(), value.getReadableBytes());
        }
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, byte[] value) {
        if (value.length > 255) {
            buffer.writeByte(-80);
            buffer.writeInt(value.length);
            buffer.writeBytes(value, 0, value.length);
        } else {
            buffer.writeByte(-96);
            buffer.writeByte((byte)value.length);
            buffer.writeBytes(value, 0, value.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRawArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte(-80);
        for (Object value : values) {
            Binary binary = (Binary)value;
            ProtonBuffer binaryBuffer = binary.asProtonBuffer();
            buffer.writeInt(binaryBuffer.getReadableBytes());
            binaryBuffer.markReadIndex();
            try {
                buffer.writeBytes(binaryBuffer);
            }
            finally {
                binaryBuffer.resetReadIndex();
            }
        }
    }
}

