/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.primitives;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.TypeEncoder;
import org.apache.qpid.protonj2.codec.encoders.PrimitiveTypeEncoder;
import org.apache.qpid.protonj2.codec.encoders.primitives.BooleanTypeEncoder;
import org.apache.qpid.protonj2.codec.encoders.primitives.ByteTypeEncoder;
import org.apache.qpid.protonj2.codec.encoders.primitives.CharacterTypeEncoder;
import org.apache.qpid.protonj2.codec.encoders.primitives.DoubleTypeEncoder;
import org.apache.qpid.protonj2.codec.encoders.primitives.FloatTypeEncoder;
import org.apache.qpid.protonj2.codec.encoders.primitives.IntegerTypeEncoder;
import org.apache.qpid.protonj2.codec.encoders.primitives.LongTypeEncoder;
import org.apache.qpid.protonj2.codec.encoders.primitives.ShortTypeEncoder;

public final class ArrayTypeEncoder
implements PrimitiveTypeEncoder<Object> {
    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public Class<Object> getTypeClass() {
        return Object.class;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, Object value) {
        if (!value.getClass().isArray()) {
            throw new IllegalArgumentException("Expected Array type but got: " + value.getClass().getSimpleName());
        }
        Class<?> componentType = value.getClass().getComponentType();
        if (componentType.isPrimitive()) {
            if (componentType == Boolean.TYPE) {
                this.writeType(buffer, state, (boolean[])value);
                return;
            } else if (componentType == Byte.TYPE) {
                this.writeType(buffer, state, (byte[])value);
                return;
            } else if (componentType == Short.TYPE) {
                this.writeType(buffer, state, (short[])value);
                return;
            } else if (componentType == Integer.TYPE) {
                this.writeType(buffer, state, (int[])value);
                return;
            } else if (componentType == Long.TYPE) {
                this.writeType(buffer, state, (long[])value);
                return;
            } else if (componentType == Float.TYPE) {
                this.writeType(buffer, state, (float[])value);
                return;
            } else if (componentType == Double.TYPE) {
                this.writeType(buffer, state, (double[])value);
                return;
            } else {
                if (componentType != Character.TYPE) throw new IllegalArgumentException("Cannot write arrays of type " + componentType.getName());
                this.writeType(buffer, state, (char[])value);
            }
            return;
        } else {
            this.writeArray(buffer, state, (Object[])value);
        }
    }

    @Override
    public void writeArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        TypeEncoder<?> typeEncoder = this.findTypeEncoder(buffer, state, values);
        if (typeEncoder.isArrayType()) {
            buffer.writeByte(-16);
            int startIndex = buffer.getWriteIndex();
            buffer.writeInt(0);
            buffer.writeInt(values.length);
            this.writeRawArray(buffer, state, values);
            long writeSize = buffer.getWriteIndex() - startIndex - 4;
            if (writeSize > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Cannot encode given array, encoded size to large: " + writeSize);
            }
            buffer.setInt(startIndex, (int)writeSize);
        } else {
            typeEncoder.writeArray(buffer, state, values);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeRawArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        TypeEncoder<?> typeEncoder = this.findTypeEncoder(buffer, state, values[0]);
        buffer.writeByte(-16);
        for (int i = 0; i < values.length; ++i) {
            int startIndex = buffer.getWriteIndex();
            buffer.writeInt(0);
            typeEncoder = this.findTypeEncoder(buffer, state, values[i]);
            if (values[i].getClass().getComponentType().isPrimitive()) {
                Class<?> componentType = values[i].getClass().getComponentType();
                if (componentType == Boolean.TYPE) {
                    buffer.writeInt(((boolean[])values[i]).length);
                    ((BooleanTypeEncoder)typeEncoder).writeRawArray(buffer, state, (boolean[])values[i]);
                } else if (componentType == Byte.TYPE) {
                    buffer.writeInt(((byte[])values[i]).length);
                    ((ByteTypeEncoder)typeEncoder).writeRawArray(buffer, state, (byte[])values[i]);
                } else if (componentType == Short.TYPE) {
                    buffer.writeInt(((short[])values[i]).length);
                    ((ShortTypeEncoder)typeEncoder).writeRawArray(buffer, state, (short[])values[i]);
                } else if (componentType == Integer.TYPE) {
                    buffer.writeInt(((int[])values[i]).length);
                    ((IntegerTypeEncoder)typeEncoder).writeRawArray(buffer, state, (int[])values[i]);
                } else if (componentType == Long.TYPE) {
                    buffer.writeInt(((long[])values[i]).length);
                    ((LongTypeEncoder)typeEncoder).writeRawArray(buffer, state, (long[])values[i]);
                } else if (componentType == Float.TYPE) {
                    buffer.writeInt(((Object[])values[i]).length);
                    ((FloatTypeEncoder)typeEncoder).writeRawArray(buffer, state, (float[])values[i]);
                } else if (componentType == Double.TYPE) {
                    buffer.writeInt(((double[])values[i]).length);
                    ((DoubleTypeEncoder)typeEncoder).writeRawArray(buffer, state, (double[])values[i]);
                } else {
                    if (componentType != Character.TYPE) throw new IllegalArgumentException("Cannot write arrays of type " + componentType.getName());
                    buffer.writeInt(((float[])values[i]).length);
                    ((CharacterTypeEncoder)typeEncoder).writeRawArray(buffer, state, (char[])values[i]);
                }
            } else {
                buffer.writeInt(((Object[])values[i]).length);
                typeEncoder.writeRawArray(buffer, state, (Object[])values[i]);
            }
            long writeSize = buffer.getWriteIndex() - startIndex - 4;
            if (writeSize > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Cannot encode given array, encoded size to large: " + writeSize);
            }
            buffer.setInt(startIndex, (int)writeSize);
        }
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, boolean[] value) {
        BooleanTypeEncoder typeEncoder = (BooleanTypeEncoder)state.getEncoder().getTypeEncoder(Boolean.class);
        typeEncoder.writeArray(buffer, state, value);
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, byte[] value) {
        ByteTypeEncoder typeEncoder = (ByteTypeEncoder)state.getEncoder().getTypeEncoder(Byte.class);
        typeEncoder.writeArray(buffer, state, value);
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, short[] value) {
        ShortTypeEncoder typeEncoder = (ShortTypeEncoder)state.getEncoder().getTypeEncoder(Short.class);
        typeEncoder.writeArray(buffer, state, value);
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, int[] value) {
        IntegerTypeEncoder typeEncoder = (IntegerTypeEncoder)state.getEncoder().getTypeEncoder(Integer.class);
        typeEncoder.writeArray(buffer, state, value);
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, long[] value) {
        LongTypeEncoder typeEncoder = (LongTypeEncoder)state.getEncoder().getTypeEncoder(Long.class);
        typeEncoder.writeArray(buffer, state, value);
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, float[] value) {
        FloatTypeEncoder typeEncoder = (FloatTypeEncoder)state.getEncoder().getTypeEncoder(Float.class);
        typeEncoder.writeArray(buffer, state, value);
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, double[] value) {
        DoubleTypeEncoder typeEncoder = (DoubleTypeEncoder)state.getEncoder().getTypeEncoder(Double.class);
        typeEncoder.writeArray(buffer, state, value);
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, char[] value) {
        CharacterTypeEncoder typeEncoder = (CharacterTypeEncoder)state.getEncoder().getTypeEncoder(Character.class);
        typeEncoder.writeArray(buffer, state, value);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TypeEncoder<?> findTypeEncoder(ProtonBuffer buffer, EncoderState state, Object value) {
        void var4_17;
        if (!value.getClass().isArray()) {
            throw new IllegalArgumentException("Expected Array type but got: " + value.getClass().getSimpleName());
        }
        Object var4_4 = null;
        if (value.getClass().getComponentType().isPrimitive()) {
            Class<?> componentType = value.getClass().getComponentType();
            if (componentType == Boolean.TYPE) {
                TypeEncoder<?> typeEncoder = state.getEncoder().getTypeEncoder(Boolean.class);
            } else if (componentType == Byte.TYPE) {
                TypeEncoder<?> typeEncoder = state.getEncoder().getTypeEncoder(Byte.class);
            } else if (componentType == Short.TYPE) {
                TypeEncoder<?> typeEncoder = state.getEncoder().getTypeEncoder(Short.class);
            } else if (componentType == Integer.TYPE) {
                TypeEncoder<?> typeEncoder = state.getEncoder().getTypeEncoder(Integer.class);
            } else if (componentType == Long.TYPE) {
                TypeEncoder<?> typeEncoder = state.getEncoder().getTypeEncoder(Long.class);
            } else if (componentType == Float.TYPE) {
                TypeEncoder<?> typeEncoder = state.getEncoder().getTypeEncoder(Float.class);
            } else if (componentType == Double.TYPE) {
                TypeEncoder<?> typeEncoder = state.getEncoder().getTypeEncoder(Double.class);
            } else {
                if (componentType != Character.TYPE) throw new IllegalArgumentException("Cannot write arrays of type " + componentType.getName());
                TypeEncoder<?> typeEncoder = state.getEncoder().getTypeEncoder(Character.class);
            }
        } else {
            Object[] array = (Object[])value;
            if (array.length == 0) {
                if (value.getClass().getComponentType().equals(Object.class)) {
                    throw new IllegalArgumentException("Cannot write a zero sized untyped array.");
                }
                TypeEncoder<?> typeEncoder = state.getEncoder().getTypeEncoder(value.getClass().getComponentType());
            } else if (array[0].getClass().isArray()) {
                ArrayTypeEncoder arrayTypeEncoder = this;
            } else {
                if (array[0].getClass().equals(Object.class)) {
                    throw new IllegalArgumentException("Cannot write a zero sized untyped array.");
                }
                TypeEncoder<?> typeEncoder = state.getEncoder().getTypeEncoder(array[0].getClass());
            }
        }
        if (var4_17 != null) return var4_17;
        throw new IllegalArgumentException("Do not know how to write Objects of class " + value.getClass().getName());
    }
}

