/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.messaging;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.encoders.AbstractDescribedListTypeEncoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedInteger;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.messaging.Source;
import org.apache.qpid.protonj2.types.messaging.TerminusDurability;
import org.apache.qpid.protonj2.types.messaging.TerminusExpiryPolicy;

public final class SourceTypeEncoder
extends AbstractDescribedListTypeEncoder<Source> {
    @Override
    public UnsignedLong getDescriptorCode() {
        return Source.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Source.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Class<Source> getTypeClass() {
        return Source.class;
    }

    @Override
    public void writeElement(Source source, int index, ProtonBuffer buffer, EncoderState state) {
        switch (index) {
            case 0: {
                state.getEncoder().writeString(buffer, state, source.getAddress());
                break;
            }
            case 1: {
                state.getEncoder().writeUnsignedInteger(buffer, state, source.getDurable().getValue());
                break;
            }
            case 2: {
                state.getEncoder().writeSymbol(buffer, state, source.getExpiryPolicy().getPolicy());
                break;
            }
            case 3: {
                state.getEncoder().writeUnsignedInteger(buffer, state, source.getTimeout());
                break;
            }
            case 4: {
                buffer.writeByte(source.isDynamic() ? 65 : 66);
                break;
            }
            case 5: {
                state.getEncoder().writeMap(buffer, state, source.getDynamicNodeProperties());
                break;
            }
            case 6: {
                state.getEncoder().writeSymbol(buffer, state, source.getDistributionMode());
                break;
            }
            case 7: {
                state.getEncoder().writeMap(buffer, state, source.getFilter());
                break;
            }
            case 8: {
                state.getEncoder().writeObject(buffer, state, source.getDefaultOutcome());
                break;
            }
            case 9: {
                state.getEncoder().writeArray(buffer, state, source.getOutcomes());
                break;
            }
            case 10: {
                state.getEncoder().writeArray(buffer, state, source.getCapabilities());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Source value index: " + index);
            }
        }
    }

    @Override
    public byte getListEncoding(Source value) {
        return -48;
    }

    @Override
    public int getElementCount(Source source) {
        if (source.getCapabilities() != null) {
            return 11;
        }
        if (source.getOutcomes() != null) {
            return 10;
        }
        if (source.getDefaultOutcome() != null) {
            return 9;
        }
        if (source.getFilter() != null) {
            return 8;
        }
        if (source.getDistributionMode() != null) {
            return 7;
        }
        if (source.getDynamicNodeProperties() != null) {
            return 6;
        }
        if (source.isDynamic()) {
            return 5;
        }
        if (source.getTimeout() != null && !source.getTimeout().equals(UnsignedInteger.ZERO)) {
            return 4;
        }
        if (source.getExpiryPolicy() != null && source.getExpiryPolicy() != TerminusExpiryPolicy.SESSION_END) {
            return 3;
        }
        if (source.getDurable() != null && source.getDurable() != TerminusDurability.NONE) {
            return 2;
        }
        if (source.getAddress() != null) {
            return 1;
        }
        return 0;
    }
}

