/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.messaging;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.encoders.AbstractDescribedTypeEncoder;
import org.apache.qpid.protonj2.types.Binary;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.messaging.Data;

public final class DataTypeEncoder
extends AbstractDescribedTypeEncoder<Data> {
    @Override
    public Class<Data> getTypeClass() {
        return Data.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return Data.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Data.DESCRIPTOR_SYMBOL;
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, Data value) {
        buffer.writeByte(0);
        buffer.writeByte(83);
        buffer.writeByte(Data.DESCRIPTOR_CODE.byteValue());
        state.getEncoder().writeBinary(buffer, state, value.getValue());
    }

    @Override
    public void writeArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte(-16);
        int startIndex = buffer.getWriteIndex();
        buffer.writeInt(0);
        buffer.writeInt(values.length);
        this.writeRawArray(buffer, state, values);
        int endIndex = buffer.getWriteIndex();
        long writeSize = endIndex - startIndex - 4;
        if (writeSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot encode given array, encoded size to large: " + writeSize);
        }
        buffer.setInt(startIndex, (int)writeSize);
    }

    @Override
    public void writeRawArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte(0);
        state.getEncoder().writeUnsignedLong(buffer, state, this.getDescriptorCode());
        buffer.writeByte(-80);
        for (Object value : values) {
            Binary binary = ((Data)value).getBinary();
            buffer.writeInt(binary.getLength());
            buffer.writeBytes(binary.getArray(), binary.getArrayOffset(), binary.getLength());
        }
    }
}

